/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

@NotNullByDefault(value=false)
public class MarkableFileInputStream
extends InputStream {
    private final RandomAccessFile randomAccessFile;
    private long mark;

    public MarkableFileInputStream(String name) throws FileNotFoundException {
        this(new File(name));
    }

    public MarkableFileInputStream(File file) throws FileNotFoundException {
        this.randomAccessFile = new RandomAccessFile(file, "r");
    }

    @Override
    public int read() throws IOException {
        return this.randomAccessFile.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.randomAccessFile.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        int tmp;
        long result = 0L;
        while (n > Integer.MAX_VALUE && (tmp = this.randomAccessFile.skipBytes(Integer.MAX_VALUE)) != 0) {
            n -= (long)tmp;
            result += (long)tmp;
        }
        return result += (long)this.randomAccessFile.skipBytes((int)n);
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(Integer.MAX_VALUE, this.randomAccessFile.length() - this.randomAccessFile.getFilePointer());
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.mark = this.randomAccessFile.getFilePointer();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.randomAccessFile.seek(this.mark);
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

