/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class LineUtil {
    private static final Charset CHARSET_ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private LineUtil() {
    }

    public static ProducerWhichThrows<String, IOException> lineProducerISO8859_1(InputStream in) {
        return LineUtil.lineProducer(new InputStreamReader(in, CHARSET_ISO_8859_1));
    }

    public static ProducerWhichThrows<String, IOException> lineProducer(Reader r) {
        final BufferedReader br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        return new ProducerWhichThrows<String, IOException>(){

            public String produce() throws IOException {
                return br.readLine();
            }
        };
    }

    public static Producer<String> lineProducer(final String text) {
        return new Producer<String>(){
            final int len;
            int offset;
            {
                this.len = text.length();
            }

            @Nullable
            public String produce() {
                if (this.offset == this.len) {
                    return null;
                }
                int o = this.offset;
                do {
                    char c;
                    if ((c = text.charAt(o)) == '\r') {
                        String result = text.substring(this.offset, o);
                        if (++o < this.len && text.charAt(o) == '\n') {
                            ++o;
                        }
                        this.offset = o;
                        return result;
                    }
                    if (c != '\n') continue;
                    String result = text.substring(this.offset, o);
                    this.offset = o + 1;
                    return result;
                } while (++o != this.len);
                String result = text.substring(this.offset);
                this.offset = o;
                return result;
            }
        };
    }

    public static Producer<CharSequence> lineProducer(final CharSequence text) {
        return new Producer<CharSequence>(){
            final int len;
            int offset;
            {
                this.len = text.length();
            }

            @Nullable
            public CharSequence produce() {
                if (this.offset == this.len) {
                    return null;
                }
                int o = this.offset;
                do {
                    char c;
                    if ((c = text.charAt(o)) == '\r') {
                        CharSequence result = text.subSequence(this.offset, o);
                        if (++o < this.len && text.charAt(o) == '\n') {
                            ++o;
                        }
                        this.offset = o;
                        return result;
                    }
                    if (c != '\n') continue;
                    CharSequence result = text.subSequence(this.offset, o);
                    this.offset = o + 1;
                    return result;
                } while (++o != this.len);
                CharSequence result = text.subSequence(this.offset, o);
                this.offset = o;
                return result;
            }
        };
    }

    public static ProducerWhichThrows<String, IOException> readLineWithSeparator(final Reader r) {
        return new ProducerWhichThrows<String, IOException>(){
            private int lookahead = -2;

            @Nullable
            public String produce() throws IOException {
                int c;
                if (this.lookahead == -2) {
                    c = r.read();
                } else {
                    c = this.lookahead;
                    this.lookahead = -2;
                }
                if (c == -1) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                do {
                    sb.append((char)c);
                    if (c == 10 || c == 133 || c == 8232 || c == 8233) {
                        return sb.toString();
                    }
                    if (c != 13) continue;
                    c = r.read();
                    if (c == 10) {
                        return sb.append('\n').toString();
                    }
                    this.lookahead = c;
                    return sb.toString();
                } while ((c = r.read()) != -1);
                return sb.toString();
            }
        };
    }

    public static ConsumerWhichThrows<String, IOException> lineConsumerISO8859_1(OutputStream out) {
        return LineUtil.lineConsumer(new OutputStreamWriter(out, CHARSET_ISO_8859_1));
    }

    public static ConsumerWhichThrows<String, IOException> lineConsumer(final Writer w) {
        return new ConsumerWhichThrows<String, IOException>(){

            public void consume(String line) throws IOException {
                w.write(line + LINE_SEPARATOR);
                w.flush();
            }
        };
    }

    public static <T extends CharSequence> Consumer<T> lineConsumer(final PrintWriter pw) {
        return new Consumer<T>(){

            public void consume(T line) {
                pw.println(line);
            }
        };
    }

    public static Consumer<String> lineConsumer(final PrintStream ps) {
        return new Consumer<String>(){

            public void consume(String line) {
                ps.println(line);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readAllLines(Reader r, boolean closeReader) throws IOException {
        try {
            String line;
            BufferedReader br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
            ArrayList<String> result = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
            if (closeReader) {
                r.close();
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            if (closeReader) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static LineAndColumnTracker lineAndColumnTracker() {
        return new LineAndColumnTracker(){
            private int tabWidth = 8;
            private int line = 1;
            private int column = 1;
            private boolean crPending;

            @Override
            public void consume(char c) {
                if (this.crPending) {
                    this.crPending = false;
                    if (c == '\n') {
                        return;
                    }
                }
                switch (c) {
                    case '\r': {
                        ++this.line;
                        this.column = 1;
                        this.crPending = true;
                        break;
                    }
                    case '\n': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.line;
                        this.column = 1;
                        break;
                    }
                    case '\t': {
                        this.column = this.column - (this.column - 1) % this.tabWidth + this.tabWidth;
                        break;
                    }
                    default: {
                        ++this.column;
                    }
                }
            }

            @Override
            public int getLineNumber() {
                return this.line;
            }

            @Override
            public void setLineNumber(int lineNumber) {
                this.line = lineNumber;
            }

            @Override
            public int getColumnNumber() {
                return this.column;
            }

            @Override
            public void setColumnNumber(int columnNumber) {
                this.column = columnNumber;
            }

            @Override
            public void setTabWidth(int tabWidth) {
                this.tabWidth = tabWidth;
            }

            @Override
            public void reset() {
                this.line = 1;
                this.column = 1;
                this.crPending = false;
            }
        };
    }

    public static interface LineAndColumnTracker {
        public static final int DEFAULT_TAB_WIDTH = 8;

        public void setTabWidth(int var1);

        public void consume(char var1);

        public int getLineNumber();

        public void setLineNumber(int var1);

        public int getColumnNumber();

        public void setColumnNumber(int var1);

        public void reset();
    }
}

