/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.EventCounter;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class InputStreams {
    public static final InputStream EMPTY = new InputStream(){

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int read(@Nullable byte[] buf, int off, int len) {
            return -1;
        }
    };
    public static final InputStream ZERO = InputStreams.constantInputStream((byte)0);

    private InputStreams() {
    }

    public static InputStream wye(InputStream in, final OutputStream out) {
        return new FilterInputStream(in){

            @Override
            public int read() throws IOException {
                int b = super.read();
                if (b == -1) {
                    out.flush();
                } else {
                    out.write(b);
                }
                return b;
            }

            @Override
            public int read(@Nullable byte[] b, int off, int len) throws IOException {
                int count = super.read(b, off, len);
                if (count > 0) {
                    out.write(b, off, count);
                }
                if (count == -1) {
                    out.flush();
                }
                return count;
            }

            @Override
            public int available() throws IOException {
                out.flush();
                return this.in.available();
            }
        };
    }

    public static int readFully(InputStream in, byte[] buffer, int offset, int len) throws IOException {
        int result = 0;
        while (len > 0) {
            int n = in.read(buffer, offset, len);
            if (n == -1) {
                return result == 0 ? -1 : result;
            }
            offset += n;
            len -= n;
            result += n;
        }
        return result;
    }

    public static byte[] readAll(InputStream is) throws IOException {
        return InputStreams.readAll(is, false);
    }

    public static byte[] readAll(InputStream is, boolean closeInputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoUtil.copy(is, closeInputStream, baos, false);
        return baos.toByteArray();
    }

    public static String readAll(InputStream inputStream, Charset charset, boolean closeInputStream) throws IOException {
        StringWriter sw = new StringWriter();
        IoUtil.copy(new InputStreamReader(inputStream, charset), closeInputStream, sw, false);
        return sw.toString();
    }

    public static long skip(InputStream inputStream, long n) throws IOException {
        long result;
        long skipped;
        for (result = 0L; result < n; result += skipped) {
            skipped = inputStream.skip(n - result);
            if (skipped != 0L) continue;
            return result;
        }
        return result;
    }

    public static long skipAll(InputStream inputStream) throws IOException {
        long result = 0L;
        long skipped;
        while ((skipped = inputStream.skip(Long.MAX_VALUE)) != 0L) {
            result += skipped;
        }
        return result;
    }

    public static InputStream constantInputStream(final byte b) {
        return new InputStream(){

            @Override
            public int read() {
                return 0;
            }

            @Override
            public int read(@Nullable byte[] buf, int off, int len) {
                Arrays.fill(buf, off, len, b);
                return len;
            }
        };
    }

    public static InputStream unclosable(InputStream delegate) {
        return new FilterInputStream(delegate){

            @Override
            public void close() {
            }
        };
    }

    public static InputStream byteProducerInputStream(final ProducerWhichThrows<? extends Byte, ? extends IOException> delegate) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                Byte b = (Byte)delegate.produce();
                return b != null ? 0xFF & b : -1;
            }
        };
    }

    public static InputStream byteProducerInputStream(Producer<? extends Byte> delegate) {
        return InputStreams.byteProducerInputStream((ProducerWhichThrows<? extends Byte, ? extends IOException>)ProducerUtil.asProducerWhichThrows(delegate));
    }

    public static InputStream randomInputStream(long seed) {
        return InputStreams.byteProducerInputStream((Producer<? extends Byte>)ProducerUtil.randomByteProducer((long)seed));
    }

    protected static InputStream deleteOnClose(InputStream delegate, final File file) {
        return new FilterInputStream(delegate){

            @Override
            public void close() throws IOException {
                super.close();
                file.delete();
            }
        };
    }

    public static InputStream onEndOfInput(InputStream delegate, final Runnable runnable) {
        return new FilterInputStream(delegate){
            boolean hadEndOfInput;

            @Override
            public int read() throws IOException {
                int b = super.read();
                if (b == -1 && !this.hadEndOfInput) {
                    this.hadEndOfInput = true;
                    runnable.run();
                }
                return b;
            }

            @Override
            public int read(@Nullable byte[] b, int off, int len) throws IOException {
                int count = super.read(b, off, len);
                if (count == -1 && !this.hadEndOfInput) {
                    this.hadEndOfInput = true;
                    runnable.run();
                }
                return count;
            }
        };
    }

    public static InputStream singlingFilterInputStream(InputStream delegate) {
        return new FilterInputStream(delegate){

            @Override
            @NotNullByDefault(value=false)
            public int read(byte[] cbuf, int off, int len) throws IOException {
                return this.in.read(cbuf, off, len <= 0 ? 0 : 1);
            }
        };
    }

    public static InputStream statisticsInputStream(InputStream delegate, final EventCounter eventCounter) {
        return new FilterInputStream(delegate){

            @Override
            public int read() throws IOException {
                int result = super.read();
                eventCounter.countEvent("read", result == -1 ? -1 : 1);
                return result;
            }

            @Override
            @NotNullByDefault(value=false)
            public int read(byte[] b, int off, int len) throws IOException {
                int result = super.read(b, off, len);
                eventCounter.countEvent("read", result);
                return result;
            }

            @Override
            public long skip(long n) throws IOException {
                long result = super.skip(n);
                eventCounter.countEvent("skip", result);
                return result;
            }

            @Override
            public int available() throws IOException {
                int result = super.available();
                eventCounter.countEvent("available", result);
                return result;
            }

            @Override
            public void close() throws IOException {
                super.close();
                eventCounter.countEvent("close");
            }

            @Override
            public synchronized void mark(int readlimit) {
                super.mark(readlimit);
                eventCounter.countEvent("mark", Integer.toString(readlimit));
            }

            @Override
            public synchronized void reset() throws IOException {
                super.reset();
                eventCounter.countEvent("reset");
            }

            @Override
            public boolean markSupported() {
                boolean result = super.markSupported();
                eventCounter.countEvent("markSupported", result);
                return result;
            }
        };
    }
}

