/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.LineUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.text.Segment;

public final class Writers {
    public static final Writer DISCARD = new Writer(){

        @Override
        public void write(int c) {
        }

        @Override
        @NotNullByDefault(value=false)
        public void write(String str, int off, int len) {
        }

        @Override
        @NotNullByDefault(value=false)
        public Writer append(CharSequence csq) {
            return this;
        }

        @Override
        @NotNullByDefault(value=false)
        public Writer append(CharSequence csq, int start, int end) {
            return this;
        }

        @Override
        @NotNullByDefault(value=false)
        public void write(char[] cbuf, int off, int len) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    };

    private Writers() {
    }

    @NotNullByDefault(value=false)
    public static Writer fromAppendable(final Appendable delegate) {
        if (delegate instanceof Writer) {
            return (Writer)delegate;
        }
        return new Writer(){

            @Override
            public void write(int c) throws IOException {
                delegate.append((char)c);
            }

            @Override
            public void write(char[] cbuf) throws IOException {
                delegate.append(new Segment(cbuf, 0, cbuf.length));
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                delegate.append(new Segment(cbuf, off, len));
            }

            @Override
            public void write(String str) throws IOException {
                delegate.append(str);
            }

            @Override
            public void write(String str, int off, int len) throws IOException {
                delegate.append(str, off, len);
            }

            @Override
            public Writer append(CharSequence csq) throws IOException {
                delegate.append(csq);
                return this;
            }

            @Override
            public Writer append(CharSequence csq, int start, int end) throws IOException {
                delegate.append(csq, start, end);
                return this;
            }

            @Override
            public Writer append(char c) throws IOException {
                delegate.append(c);
                return this;
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
    }

    public static Writer onFirstChar(Writer out, final Runnable runnable) {
        return new FilterWriter(out){
            private boolean hadChars;

            @Override
            public void write(int c) throws IOException {
                this.aboutToWrite();
                super.write(c);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.aboutToWrite();
                super.write(cbuf, off, len);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(String str, int off, int len) throws IOException {
                this.aboutToWrite();
                super.write(str, off, len);
            }

            private void aboutToWrite() {
                if (!this.hadChars) {
                    runnable.run();
                    this.hadChars = true;
                }
            }
        };
    }

    public static Writer trackLineAndColumn(Writer out, final LineUtil.LineAndColumnTracker tracker) {
        return new FilterWriter(out){

            @Override
            public void write(int c) throws IOException {
                super.write(c);
                tracker.consume((char)c);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(char[] cbuf, int off, int len) throws IOException {
                while (len > 0) {
                    this.write(cbuf[off++]);
                    --len;
                }
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(String str, int off, int len) throws IOException {
                while (len > 0) {
                    this.write(str.charAt(off++));
                    --len;
                }
            }
        };
    }

    public static Writer tee(final Writer ... delegates) {
        return new Writer(){

            @Override
            public void close() throws IOException {
                IOException caughtIOException = null;
                for (Writer delegate : delegates) {
                    try {
                        delegate.close();
                    }
                    catch (IOException ioe) {
                        caughtIOException = ioe;
                    }
                }
                if (caughtIOException != null) {
                    throw caughtIOException;
                }
            }

            @Override
            public void flush() throws IOException {
                for (Writer delegate : delegates) {
                    delegate.flush();
                }
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(char[] b, int off, int len) throws IOException {
                for (Writer delegate : delegates) {
                    delegate.write(b, off, len);
                }
            }

            @Override
            public void write(int b) throws IOException {
                for (Writer delegate : delegates) {
                    delegate.write(b);
                }
            }
        };
    }

    public static Writer autoFlushing(Writer out) {
        return new FilterWriter(out){

            @Override
            public void write(int c) throws IOException {
                this.out.write(c);
                this.out.flush();
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.out.write(cbuf, off, len);
                this.out.flush();
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(String str, int off, int len) throws IOException {
                this.out.write(str, off, len);
                this.out.flush();
            }
        };
    }
}

