/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.EventCounter;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.MarkableFileInputStream;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public final class OutputStreams {
    public static final OutputStream DISCARD = new OutputStream(){

        @Override
        public void write(@Nullable byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }
    };
    private static final long[] THRESHOLDS = new long[126];

    private OutputStreams() {
    }

    @NotNullByDefault(value=false)
    public static OutputStream tee(final OutputStream ... delegates) {
        return new OutputStream(){

            @Override
            public void close() throws IOException {
                IOException caughtIOException = null;
                for (OutputStream delegate : delegates) {
                    try {
                        delegate.close();
                    }
                    catch (IOException ioe) {
                        caughtIOException = ioe;
                    }
                }
                if (caughtIOException != null) {
                    throw caughtIOException;
                }
            }

            @Override
            public void flush() throws IOException {
                for (OutputStream delegate : delegates) {
                    delegate.flush();
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                for (OutputStream delegate : delegates) {
                    delegate.write(b, off, len);
                }
            }

            @Override
            public void write(int b) throws IOException {
                for (OutputStream delegate : delegates) {
                    delegate.write(b);
                }
            }
        };
    }

    public static long writeAndCount(ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents, OutputStream outputStream) throws IOException {
        ConsumerUtil.Produmer count = ConsumerUtil.store();
        writeContents.consume((Object)OutputStreams.tee(outputStream, OutputStreams.lengthWritten((ConsumerWhichThrows<? super Integer, ? extends RuntimeException>)ConsumerUtil.cumulate((ConsumerWhichThrows)count, (long)0L))));
        Long result = (Long)count.produce();
        return result == null ? 0L : result;
    }

    public static OutputStream split(final ProducerWhichThrows<? extends OutputStream, ? extends IOException> delegates, final Producer<? extends Long> byteCountLimits) throws IOException {
        return new OutputStream(){
            private OutputStream delegate;
            private long delegateByteCount;
            {
                this.delegate = (OutputStream)AssertionUtil.notNull((Object)delegates.produce(), (String)"'delegates' produced <null>");
                this.delegateByteCount = (Long)AssertionUtil.notNull((Object)byteCountLimits.produce(), (String)"'byteCountLimits' produced <null>");
            }

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public synchronized void write(@Nullable byte[] b, int off, int len) throws IOException {
                while ((long)len > this.delegateByteCount) {
                    this.delegate.write(b, off, (int)this.delegateByteCount);
                    this.delegate.close();
                    off = (int)((long)off + this.delegateByteCount);
                    len = (int)((long)len - this.delegateByteCount);
                    this.delegate = (OutputStream)AssertionUtil.notNull((Object)delegates.produce(), (String)"'delegates' produced <null>");
                    this.delegateByteCount = (Long)AssertionUtil.notNull((Object)byteCountLimits.produce(), (String)"'byteCountLimits' produced <null>");
                }
                this.delegate.write(b, off, len);
                this.delegateByteCount -= (long)len;
            }

            @Override
            public void flush() throws IOException {
                this.delegate.flush();
            }

            @Override
            public void close() throws IOException {
                this.delegate.close();
            }
        };
    }

    @Deprecated
    public static OutputStream unclosableOutputStream(OutputStream delegate) {
        return OutputStreams.unclosable(delegate);
    }

    public static OutputStream unclosable(OutputStream delegate) {
        return new FilterOutputStream(delegate){

            @Override
            public void close() {
            }

            @Override
            public void write(@Nullable byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }
        };
    }

    public static void fill(OutputStream outputStream, byte b, long count) throws IOException {
        byte[] ba;
        if (count > 8192L) {
            ba = new byte[8192];
            if (b != 0) {
                Arrays.fill(ba, b);
            }
            do {
                outputStream.write(ba);
            } while ((count -= 8192L) > 8192L);
        }
        ba = new byte[(int)count];
        Arrays.fill(ba, b);
        outputStream.write(ba);
    }

    public static OutputStream byteConsumerOutputStream(final ConsumerWhichThrows<? super Byte, ? extends IOException> delegate) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                delegate.consume((Object)((byte)b));
            }
        };
    }

    public static OutputStream[] compareOutput(final int n, Runnable whenIdentical, Runnable whenNotIdentical) {
        abstract class ChecksumOutputStream
        extends OutputStream {
            private final Checksum checksum = new CRC32();
            private long count;
            protected final long[] checksums = new long[OutputStreams.access$000().length];
            protected int idx;
            private boolean closed;

            ChecksumOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                if (this.closed) {
                    throw new IOException("Stream is closed");
                }
                if (this.count == THRESHOLDS[this.idx]) {
                    this.pushChecksum();
                }
                this.checksum.update(b);
                ++this.count;
            }

            @Override
            public void write(@Nullable byte[] b, int off, int len) throws IOException {
                assert (b != null);
                if (this.closed) {
                    throw new IOException("Stream is closed");
                }
                while (this.count + (long)len > THRESHOLDS[this.idx]) {
                    int part = (int)Math.min(Integer.MAX_VALUE, THRESHOLDS[this.idx] - this.count);
                    this.checksum.update(b, off, part);
                    this.count = THRESHOLDS[this.idx];
                    this.pushChecksum();
                    off += part;
                    len -= part;
                }
                this.checksum.update(b, off, len);
                this.count += (long)len;
            }

            private void pushChecksum() {
                this.checksums[this.idx] = this.checksum.getValue();
                this.checksumWasPushed(this.idx);
                ++this.idx;
            }

            abstract void checksumWasPushed(int var1);

            @Override
            public void close() {
                if (this.closed) {
                    return;
                }
                this.pushChecksum();
                this.closed = true;
                this.wasClosed();
            }

            abstract void wasClosed();
        }
        OutputStream[] result = new ChecksumOutputStream[n];
        for (int i = 0; i < n; ++i) {
            result[i] = new ChecksumOutputStream((ChecksumOutputStream[])result, whenNotIdentical, whenIdentical){
                final /* synthetic */ ChecksumOutputStream[] val$result;
                final /* synthetic */ Runnable val$whenNotIdentical;
                final /* synthetic */ Runnable val$whenIdentical;
                {
                    this.val$result = checksumOutputStreamArray;
                    this.val$whenNotIdentical = runnable;
                    this.val$whenIdentical = runnable2;
                }

                @Override
                void checksumWasPushed(int idx) {
                    for (int i = 0; i < n; ++i) {
                        if (this.val$result[i].idx != idx + 1 || this.val$result[i].checksums[idx] == this.checksums[idx]) continue;
                        this.val$whenNotIdentical.run();
                        return;
                    }
                }

                @Override
                void wasClosed() {
                    for (int i = 0; i < n; ++i) {
                        if (!this.val$result[i].closed) {
                            return;
                        }
                        if (this.val$result[i].idx == this.idx && this.val$result[i].checksums[this.idx - 1] == this.checksums[this.idx - 1]) continue;
                        this.val$whenNotIdentical.run();
                        return;
                    }
                    this.val$whenIdentical.run();
                }
            };
        }
        return result;
    }

    public static OutputStream lengthWritten(final ConsumerWhichThrows<? super Integer, ? extends RuntimeException> delegate) {
        return new OutputStream(){

            @Override
            public void write(int b) {
                delegate.consume((Object)1);
            }

            @Override
            public void write(@Nullable byte[] b, int off, int len) {
                delegate.consume((Object)len);
            }
        };
    }

    public static OutputStream updatesChecksum(final Checksum checksum) {
        return new OutputStream(){

            @Override
            public void write(int b) {
                checksum.update(b);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(byte[] b, int off, int len) {
                checksum.update(b, off, len);
            }
        };
    }

    public static OutputStream statisticsOutputStream(OutputStream delegate, final EventCounter eventCounter) {
        return new FilterOutputStream(delegate){

            @Override
            public void write(int b) throws IOException {
                super.write(b);
                eventCounter.countEvent("write", 1);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(byte[] b) throws IOException {
                super.write(b);
                eventCounter.countEvent("write", b.length);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                eventCounter.countEvent("write", len);
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                eventCounter.countEvent("flush");
            }

            @Override
            public void close() throws IOException {
                eventCounter.countEvent("close");
                super.close();
            }
        };
    }

    public static OutputStream autoFlushing(OutputStream out) {
        return new FilterOutputStream(out){

            @Override
            public void write(int b) throws IOException {
                this.out.write(b);
                this.out.flush();
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
                this.out.flush();
            }
        };
    }

    public static OutputStream newOverwritingFileOutputStream(final File file) throws IOException {
        if (!file.exists()) {
            return new FileOutputStream(file);
        }
        final MarkableFileInputStream is = new MarkableFileInputStream(file);
        final File newFile = new File(file.getParent(), file.getName() + ".new");
        return new OutputStream(){
            @Nullable
            OutputStream os = null;
            byte[] readBuffer = new byte[4096];
            long pos = 0L;

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b});
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(byte[] b, int off, int len) throws IOException {
                if (this.os != null) {
                    this.os.write(b, off, len);
                    return;
                }
                if (len > this.readBuffer.length) {
                    this.readBuffer = new byte[len];
                }
                int off2 = 0;
                while (len > 0) {
                    int n = is.read(this.readBuffer, off2, len);
                    if (n == -1) {
                        this.switchToFos();
                        OutputStream os2 = this.os;
                        os2.write(b, off, len);
                        return;
                    }
                    if (!OutputStreams.arrayEquals(this.readBuffer, off2, off2 + n, b, off, off + n)) {
                        this.switchToFos();
                        OutputStream os2 = this.os;
                        os2.write(b, off, len);
                        return;
                    }
                    this.pos += (long)n;
                    off2 += n;
                    off += n;
                    len -= n;
                }
            }

            @Override
            public void flush() throws IOException {
                if (this.os != null) {
                    this.os.flush();
                }
            }

            @Override
            public void close() throws IOException {
                if (this.os != null) {
                    is.close();
                    OutputStream os2 = this.os;
                    os2.close();
                    if (!file.delete()) {
                        throw new IOException("Could not delete original file \"" + file + "\"");
                    }
                    if (!newFile.renameTo(file)) {
                        throw new IOException("Could not rename new file \"" + newFile + "\" to original file \"" + file + "\"");
                    }
                    return;
                }
                int b = is.read();
                if (b == -1) {
                    is.close();
                    return;
                }
                this.switchToFos();
                OutputStream os2 = this.os;
                os2.close();
                if (!file.delete()) {
                    throw new IOException("Could not delete original file \"" + file + "\"");
                }
                if (!newFile.renameTo(file)) {
                    throw new IOException("Could not rename new file \"" + newFile + "\" to original file \"" + file + "\"");
                }
            }

            private void switchToFos() throws IOException {
                this.os = new FileOutputStream(newFile);
                FileOutputStream os2 = this.os;
                is.reset();
                if (IoUtil.copy(is, (OutputStream)os2, this.pos) != this.pos) {
                    throw new EOFException();
                }
                is.close();
            }
        };
    }

    static boolean arrayEquals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        if (aLen < 0) {
            new IllegalArgumentException("fromIndex(" + aFromIndex + ") > toIndex(" + aToIndex + ")");
        }
        if (bLen < 0) {
            new IllegalArgumentException("fromIndex(" + bFromIndex + ") > toIndex(" + bToIndex + ")");
        }
        if (aLen != bLen) {
            return false;
        }
        while (aLen > 0) {
            if (a[aFromIndex++] != b[bFromIndex++]) {
                return false;
            }
            --aLen;
        }
        return true;
    }

    static {
        long x = 2L;
        int i = 0;
        while (i < THRESHOLDS.length) {
            OutputStreams.THRESHOLDS[i++] = x;
            OutputStreams.THRESHOLDS[i++] = x + (x >> 1);
            x <<= 1;
        }
    }
}

