/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.Comparators;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class EventCounter {
    protected Map<String, AtomicLong> events = new HashMap<String, AtomicLong>();
    protected List<Map.Entry<String, AtomicLong>> sortedEvents = new ArrayList<Map.Entry<String, AtomicLong>>();

    public void countEvent(String eventName) {
        this.countEvent(eventName, null);
    }

    public void countEvent(String eventName, @Nullable Object arg) {
        if (arg == null) {
            this.increment(eventName, 1L);
        } else if (arg instanceof Number) {
            this.increment(eventName, 1L);
            this.increment(eventName + "_", ((Number)arg).longValue());
        } else {
            this.increment(eventName, 1L);
            this.increment(eventName + ":" + arg, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increment(String key, long delta) {
        AtomicLong value = this.events.get(key);
        if (value == null) {
            EventCounter eventCounter = this;
            synchronized (eventCounter) {
                HashMap<String, AtomicLong> tmp = new HashMap<String, AtomicLong>(this.events);
                value = new AtomicLong(delta);
                tmp.put(key, value);
                ArrayList<Map.Entry<String, AtomicLong>> tmp2 = new ArrayList<Map.Entry<String, AtomicLong>>();
                tmp2.addAll(tmp.entrySet());
                Collections.sort(tmp2, Comparators.keyComparator((Comparator)Comparators.nullSafeComparator((Comparator)Comparators.naturalOrderComparator())));
                this.events = tmp;
                this.sortedEvents = tmp2;
            }
        } else {
            value.addAndGet(delta);
        }
    }
}

