/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.IOException;
import java.io.Writer;
import javax.swing.text.Segment;

public class ConsumingWriter
extends Writer {
    private final ConsumerWhichThrows<? super CharSequence, ? extends IOException> consumer;

    public static Writer create(ConsumerWhichThrows<? super CharSequence, ? extends IOException> consumer) {
        return new ConsumingWriter(consumer);
    }

    public ConsumingWriter(ConsumerWhichThrows<? super CharSequence, ? extends IOException> consumer) {
        this.consumer = consumer;
    }

    @Override
    @NotNullByDefault(value=false)
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.append(new Segment(cbuf, off, len));
    }

    @Override
    @NotNullByDefault(value=false)
    public void write(String str, int off, int len) throws IOException {
        this.append(str, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.consumer.consume((Object)"");
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    @NotNullByDefault(value=false)
    public Writer append(CharSequence csq) throws IOException {
        if (csq.length() > 0) {
            this.consumer.consume((Object)csq);
        }
        return this;
    }

    @Override
    @NotNullByDefault(value=false)
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (end > start) {
            this.append(csq.subSequence(start, end));
        }
        return this;
    }
}

