/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@NotNullByDefault(value=false)
public class AsyncBufferedOutputStream
extends FilterOutputStream {
    private ByteBuffer buffer;
    private State state = State.EMPTY;
    private int tail;
    private int head;
    private final int capacity;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    private Exception exception;

    public AsyncBufferedOutputStream(OutputStream out, ByteBuffer buffer, boolean fair) {
        super(out);
        this.buffer = buffer;
        this.capacity = buffer.capacity();
        this.lock = new ReentrantLock(fair);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
        new Thread(){

            @Override
            public void run() {
                try {
                    AsyncBufferedOutputStream.this.drain();
                }
                catch (Exception e) {
                    AsyncBufferedOutputStream.this.exception = e;
                }
            }
        }.start();
    }

    @Override
    public void write(int b) throws IOException {
        this.lock.lock();
        try {
            if (this.state == State.CLOSED) {
                throw new IOException("Stream is closed");
            }
            this.waitUntilNotFull();
            this.buffer.put(this.tail, (byte)b);
            this.tail = (this.tail + 1) % this.capacity;
            this.state = this.tail == this.head ? State.FULL : State.PART;
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void write(byte[] ba, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > ba.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.lock.lock();
        try {
            if (this.state == State.CLOSED) {
                throw new IOException("Stream is closed");
            }
            while (true) {
                int n;
                this.waitUntilNotFull();
                this.buffer.position(this.tail);
                int n2 = n = this.head <= this.tail ? this.capacity - this.tail : this.head - this.tail;
                if (len <= n) {
                    this.buffer.put(ba, off, len);
                    this.tail += len;
                    this.state = State.PART;
                    this.notEmpty.signal();
                    return;
                }
                this.buffer.put(ba, off, n);
                this.tail = (this.tail + n) % this.capacity;
                this.state = this.tail == this.head ? State.FULL : State.PART;
                off += n;
                len -= n;
                this.notEmpty.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.lock.lock();
        try {
            if (this.state == State.CLOSED) {
                throw new IOException("Stream is closed");
            }
            this.waitUntilEmpty();
            this.out.flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.flush();
            this.state = State.CLOSED;
            this.buffer = null;
            this.out.close();
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitUntilNotFull() throws IOException {
        try {
            while (this.state == State.FULL) {
                this.notFull.await();
            }
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException();
        }
        this.checkException();
    }

    private void waitUntilEmpty() throws IOException {
        try {
            while (this.state != State.EMPTY) {
                this.notFull.await();
            }
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException();
        }
        this.checkException();
    }

    private void waitUntilNotEmpty() throws IOException {
        try {
            while (this.state == State.EMPTY) {
                this.notEmpty.await();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        this.checkException();
    }

    private void checkException() throws IOException {
        if (this.exception == null) {
            return;
        }
        if (this.exception instanceof IOException) {
            throw (IOException)ExceptionUtil.wrap(null, (Throwable)((IOException)this.exception));
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)ExceptionUtil.wrap(null, (Throwable)((RuntimeException)this.exception));
        }
        throw (IOException)ExceptionUtil.wrap(null, (Throwable)this.exception, IOException.class);
    }

    private void drain() throws IOException {
        this.lock.lock();
        try {
            while (this.state != State.CLOSED) {
                this.waitUntilNotEmpty();
                while (this.state == State.PART || this.state == State.FULL) {
                    int n;
                    int n2 = n = this.head >= this.tail ? this.capacity - this.head : this.tail - this.head;
                    if (n > 4096) {
                        n = 4096;
                    }
                    byte[] ba = new byte[n];
                    ((Buffer)this.buffer).position(this.head);
                    this.buffer.get(ba);
                    this.head = (this.head + n) % this.capacity;
                    if (this.head == this.tail) {
                        this.state = State.EMPTY;
                    }
                    this.notFull.signal();
                    this.out.write(ba);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static enum State {
        CLOSED,
        EMPTY,
        PART,
        FULL;

    }
}

