/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io.pipe;

import de.unkrig.commons.io.BlockingException;
import de.unkrig.commons.io.pipe.AbstractPipe;
import de.unkrig.commons.io.pipe.Pipe;
import de.unkrig.commons.io.pipe.PipeFactory;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public final class PipeUtil {
    private PipeUtil() {
    }

    public static InputOutputStreams asInputOutputStreams(Pipe pipe) {
        return PipeUtil.asInputOutputStreams(pipe, true);
    }

    public static InputOutputStreams asInputOutputStreams(final Pipe pipe, final boolean blocking) {
        class MyInputOutputStreams
        implements InputOutputStreams {
            boolean inputStreamClosed;
            boolean outputStreamClosed;
            InputStream inputStream = new InputStream(){

                @Override
                public int available() {
                    return pipe.isEmpty() ? 0 : 1;
                }

                @Override
                public int read() throws IOException {
                    byte[] ba = new byte[1];
                    if (this.read(ba, 0, 1) == -1) {
                        return -1;
                    }
                    return 0xFF & ba[0];
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized int read(@Nullable byte[] buf, int off, int len) throws IOException {
                    assert (buf != null);
                    while (true) {
                        boolean wasFull = pipe.isFull();
                        int n = pipe.read(buf, off, len);
                        if (n > 0) {
                            if (wasFull) {
                                OutputStream outputStream = outputStream;
                                synchronized (outputStream) {
                                    outputStream.notifyAll();
                                }
                            }
                            return n;
                        }
                        if (outputStreamClosed) {
                            return -1;
                        }
                        if (!blocking) {
                            throw new BlockingException();
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            throw (InterruptedIOException)new InterruptedIOException().initCause(ie);
                        }
                    }
                }

                @Override
                public void close() throws IOException {
                    inputStreamClosed = true;
                    pipe.close();
                }
            };
            OutputStream outputStream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    this.write(new byte[]{(byte)b}, 0, 1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized void write(@Nullable byte[] buf, int off, int len) throws IOException {
                    assert (buf != null);
                    while (true) {
                        if (inputStreamClosed) {
                            throw new EOFException();
                        }
                        boolean wasEmpty = pipe.isEmpty();
                        int n = pipe.write(buf, off, len);
                        if (wasEmpty) {
                            InputStream inputStream = inputStream;
                            synchronized (inputStream) {
                                inputStream.notifyAll();
                            }
                        }
                        if (n == len) {
                            return;
                        }
                        if (n == 0) {
                            if (!blocking) {
                                throw new BlockingException();
                            }
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ie) {
                                throw (InterruptedIOException)new InterruptedIOException().initCause(ie);
                            }
                        }
                        off += n;
                        len -= n;
                    }
                }

                @Override
                public void close() {
                    outputStreamClosed = true;
                }
            };

            MyInputOutputStreams() {
            }

            @Override
            public InputStream getInputStream() {
                return this.inputStream;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.outputStream;
            }
        }
        return new MyInputOutputStreams();
    }

    public static Pipe deleteFileOnClose(Pipe delegate, final File file) {
        return PipeUtil.onClose(delegate, new RunnableWhichThrows<IOException>(){

            public void run() throws IOException {
                if (!file.delete()) {
                    throw new IOException("delete");
                }
            }
        });
    }

    public static Pipe onClose(final Pipe delegate, final RunnableWhichThrows<IOException> runnable) {
        return new AbstractPipe(){

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                return delegate.read(buf, off, len);
            }

            @Override
            public int write(byte[] buf, int off, int len) throws IOException {
                return delegate.write(buf, off, len);
            }

            @Override
            public boolean isEmpty() {
                return delegate.isEmpty();
            }

            @Override
            public boolean isFull() {
                return delegate.isFull();
            }

            @Override
            public void close() throws IOException {
                try {
                    delegate.close();
                }
                finally {
                    runnable.run();
                }
            }
        };
    }

    public static void temporaryStorage(FillerAndDrainer fillerAndDrainer) throws IOException {
        PipeUtil.temporaryStorage(fillerAndDrainer, fillerAndDrainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void temporaryStorage(Filler filler, Drainer drainer) throws IOException {
        InputOutputStreams ios = PipeUtil.asInputOutputStreams(PipeFactory.elasticPipe());
        OutputStream os = ios.getOutputStream();
        InputStream is = ios.getInputStream();
        try {
            filler.fill(os);
            os.close();
            drainer.drain(is);
            is.close();
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
            try {
                os.close();
            }
            catch (Exception e) {}
        }
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    @NotNullByDefault
    public static interface FillerAndDrainer
    extends Filler,
    Drainer {
    }

    @NotNullByDefault
    public static interface Drainer {
        public void drain(InputStream var1) throws IOException;
    }

    @NotNullByDefault
    public static interface Filler {
        public void fill(OutputStream var1) throws IOException;
    }

    public static interface InputOutputStreams {
        public InputStream getInputStream();

        public OutputStream getOutputStream();
    }
}

