/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class HexOutputStream
extends OutputStream {
    private static final int BYTES_PER_LINE = 32;
    private final PrintWriter out;
    private final byte[] buffer = new byte[32];
    private int cur;
    private long offset;
    private boolean crPending;

    public HexOutputStream(Writer out) {
        this.out = new PrintWriter(out, true);
    }

    @Override
    public void flush() {
        int j;
        if (this.cur == 0) {
            return;
        }
        this.out.printf("%06x", this.offset);
        for (j = 0; j < 32 && j < this.cur; ++j) {
            this.out.printf(j == 16 ? "-%02x" : " %02x", 0xFF & this.buffer[j]);
        }
        while (j < 32) {
            this.out.print("   ");
            ++j;
        }
        this.out.print("-");
        for (j = 0; j < 32 && j < this.cur; ++j) {
            int c = 0xFF & this.buffer[j];
            this.out.print(c >= 32 && c <= 126 ? (char)c : (char)'.');
        }
        this.out.println();
        this.offset += (long)this.cur;
        this.cur = 0;
    }

    @Override
    public void write(int b) {
        if (this.crPending) {
            if (b != 10) {
                this.flush();
            }
            this.crPending = false;
        }
        this.buffer[this.cur++] = (byte)b;
        if (b == 10 || this.cur == this.buffer.length) {
            this.flush();
        } else if (b == 13) {
            this.crPending = true;
        }
    }
}

