/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.fileprocessing;

import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileContentsProcessor<T>
implements FileProcessor<T> {
    protected final ContentsProcessor<T> contentsProcessor;

    public FileContentsProcessor(ContentsProcessor<T> contentsProcessor) {
        this.contentsProcessor = contentsProcessor;
    }

    @Override
    @Nullable
    public T process(String path, final File file) throws FileNotFoundException, IOException {
        T t;
        FileInputStream is = new FileInputStream(file);
        try {
            this.contentsProcessor.process(file.getPath(), is, file.length(), -1L, new ProducerWhichThrows<InputStream, IOException>(){

                @Nullable
                public InputStream produce() throws IOException {
                    return new FileInputStream(file);
                }
            });
            ((InputStream)is).close();
            t = null;
        }
        catch (IOException ioe) {
            throw (IOException)ExceptionUtil.wrap((String)file.getPath(), (Throwable)ioe);
        }
        catch (RuntimeException re) {
            throw (RuntimeException)ExceptionUtil.wrap((String)file.getPath(), (Throwable)re);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
        return t;
    }
}

