/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.filetransformation;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.FileUtil;
import de.unkrig.commons.file.filetransformation.FileTransformations;
import de.unkrig.commons.file.filetransformation.FileTransformer;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;

public class DirectoryTransformer
implements FileTransformer {
    public static final Collator DEFAULT_MEMBER_NAME_COMPARATOR = Collator.getInstance();
    private final FileTransformer regularFileTransformer;
    private final ExceptionHandler<IOException> exceptionHandler;
    private final FileTransformer directoryMemberTransformer;
    private final FileTransformations.DirectoryCombiner directoryCombiner;
    @Nullable
    private final Comparator<Object> directoryMemberNameComparator;
    private final boolean saveSpace;
    private final boolean keepOriginals;

    public DirectoryTransformer(FileTransformer regularFileTransformer, @Nullable Comparator<Object> directoryMemberNameComparator, FileTransformer directoryMemberTransformer, FileTransformations.DirectoryCombiner directoryCombiner, boolean saveSpace, boolean keepOriginals, ExceptionHandler<IOException> exceptionHandler) {
        this.regularFileTransformer = regularFileTransformer;
        this.directoryMemberNameComparator = directoryMemberNameComparator;
        this.directoryMemberTransformer = directoryMemberTransformer;
        this.directoryCombiner = directoryCombiner;
        this.saveSpace = saveSpace;
        this.keepOriginals = keepOriginals;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void transform(String path, File in, File out, FileTransformer.Mode mode) throws IOException {
        if (!in.isDirectory()) {
            this.regularFileTransformer.transform(path, in, out, mode);
            return;
        }
        if (in.equals(out)) {
            this.transformDirectoryInPlace(path, in, mode);
        } else {
            this.transformDirectoryOutOfPlace(path, in, out, mode);
        }
    }

    private void transformDirectoryInPlace(String path, File directory, FileTransformer.Mode mode) throws IOException {
        if (this.saveSpace || mode == FileTransformer.Mode.CHECK) {
            this.transformMembers(path, directory, directory, mode);
            return;
        }
        File newDirectory = FileTransformations.newFile(directory);
        if (newDirectory.exists()) {
            FileUtil.deleteRecursively(newDirectory);
        }
        if (!newDirectory.mkdirs()) {
            throw new IOException("Could not create directory '" + newDirectory + "'");
        }
        try {
            this.transformMembers(path, directory, newDirectory, mode);
        }
        catch (IOException ioe) {
            try {
                FileUtil.deleteRecursively(newDirectory);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.exceptionHandler.handle(path, ioe);
        }
        catch (RuntimeException re) {
            try {
                FileUtil.deleteRecursively(newDirectory);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.exceptionHandler.handle(path, re);
        }
        if (this.keepOriginals) {
            File origDirectory = FileTransformations.origFile(directory);
            if (origDirectory.exists()) {
                FileUtil.deleteRecursively(origDirectory);
            }
            FileUtil.rename(directory, origDirectory);
        } else {
            FileUtil.deleteRecursively(directory);
        }
        FileUtil.rename(newDirectory, directory);
    }

    private void transformDirectoryOutOfPlace(String path, File in, File out, FileTransformer.Mode mode) throws IOException {
        boolean mkdirsOut;
        for (File p = out.getParentFile(); p != null; p = p.getParentFile()) {
            if (!p.equals(in)) continue;
            throw new IOException("Output directory '" + out + "' must not be created under input directory '" + in + "'");
        }
        boolean bl = mkdirsOut = (mode == FileTransformer.Mode.TRANSFORM || mode == FileTransformer.Mode.CHECK_AND_TRANSFORM) && !out.isDirectory();
        if (mkdirsOut && !out.mkdirs()) {
            throw new IOException("Could not create directory '" + out + "'");
        }
        try {
            this.transformMembers(path, in, out, mode);
        }
        catch (IOException ioe) {
            if (mkdirsOut) {
                try {
                    FileUtil.deleteRecursively(out);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.exceptionHandler.handle(path, ioe);
        }
        catch (RuntimeException re) {
            if (mkdirsOut) {
                try {
                    FileUtil.deleteRecursively(out);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.exceptionHandler.handle(path, re);
        }
    }

    private void transformMembers(String path, File inputDirectory, final File outputDirectory, FileTransformer.Mode mode) throws IOException {
        String[] memberNames = inputDirectory.list();
        if (this.directoryMemberNameComparator != null) {
            Arrays.sort(memberNames, this.directoryMemberNameComparator);
        }
        for (String memberName : memberNames) {
            String memberPath = path + File.separatorChar + memberName;
            try {
                this.directoryMemberTransformer.transform(memberPath, new File(inputDirectory, memberName), new File(outputDirectory, memberName), mode);
            }
            catch (IOException ioe) {
                this.exceptionHandler.handle(memberPath, ioe);
            }
            catch (RuntimeException re) {
                this.exceptionHandler.handle(memberPath, re);
            }
        }
        this.directoryCombiner.combineDirectory(path, (ConsumerWhichThrows<? super FileTransformations.NameAndContents, ? extends IOException>)new ConsumerWhichThrows<FileTransformations.NameAndContents, IOException>(){

            public void consume(FileTransformations.NameAndContents nac) throws IOException {
                IoUtil.copy((InputStream)nac.open(), (boolean)true, (File)new File(outputDirectory, nac.getName()));
            }
        });
    }

    public String toString() {
        return "DIRECTORY=>" + this.regularFileTransformer;
    }
}

