/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.fileprocessing;

import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;

public class SelectiveFileProcessor<T>
implements FileProcessor<T> {
    private final Predicate<? super String> pathPredicate;
    private final FileProcessor<T> delegate1;
    private final FileProcessor<T> delegate2;

    public SelectiveFileProcessor(Predicate<? super String> pathPredicate, FileProcessor<T> delegate1, FileProcessor<T> delegate2) {
        this.pathPredicate = pathPredicate;
        this.delegate1 = delegate1;
        this.delegate2 = delegate2;
    }

    @Override
    @Nullable
    public T process(String path, File file) throws IOException, InterruptedException {
        if (this.pathPredicate.evaluate((Object)file.getPath())) {
            return this.delegate1.process(path, file);
        }
        return this.delegate2.process(path, file);
    }

    public String toString() {
        return this.pathPredicate + " ? (" + this.delegate1 + ") : (" + this.delegate2 + ")";
    }
}

