/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.resourceprocessing;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessings;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.fileprocessing.FileProcessings;
import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.file.resourceprocessing.ResourceProcessor;
import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.concurrent.SquadExecutor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Comparator;
import java.util.Date;
import java.util.regex.Pattern;

public final class ResourceProcessings {
    public static final URL STDIN_URL;
    private static final Pattern LOOKS_LIKE_URL;

    private ResourceProcessings() {
    }

    public static <T> ResourceProcessor<T> compressedAndArchiveResourceProcessor(Predicate<? super String> lookIntoFormat, Predicate<? super String> pathPredicate, ContentsProcessor<T> archiveContentsProcessor, ContentsProcessings.ArchiveCombiner<T> archiveEntryCombiner, ContentsProcessor<T> compressedContentsProcessor, ContentsProcessor<T> normalContentsProcessor, ExceptionHandler<IOException> exceptionHandler) {
        return ResourceProcessings.fromContentsProcessorAndFileProcessor(ContentsProcessings.compressedAndArchiveContentsProcessor(lookIntoFormat, pathPredicate, archiveContentsProcessor, archiveEntryCombiner, compressedContentsProcessor, normalContentsProcessor, exceptionHandler), FileProcessings.compressedAndArchiveFileProcessor(lookIntoFormat, pathPredicate, archiveContentsProcessor, archiveEntryCombiner, compressedContentsProcessor, normalContentsProcessor, exceptionHandler));
    }

    public static <T> ResourceProcessor<T> recursiveCompressedAndArchiveResourceProcessor(Predicate<? super String> lookIntoFormat, Predicate<? super String> pathPredicate, @Nullable Comparator<Object> directoryMemberNameComparator, boolean recurseSubdirectories, FileProcessings.DirectoryCombiner<T> directoryEntryCombiner, ContentsProcessings.ArchiveCombiner<T> archiveEntryCombiner, ContentsProcessor<T> normalContentsProcessor, SquadExecutor<T> squadExecutor, ExceptionHandler<IOException> exceptionHandler) {
        FileProcessor<T> fp = FileProcessings.recursiveCompressedAndArchiveFileProcessor(lookIntoFormat, pathPredicate, archiveEntryCombiner, normalContentsProcessor, exceptionHandler);
        fp = recurseSubdirectories ? FileProcessings.directoryTreeProcessor(pathPredicate, fp, directoryMemberNameComparator, directoryEntryCombiner, squadExecutor, exceptionHandler) : FileProcessings.directoryProcessor(pathPredicate, fp, directoryMemberNameComparator, fp, directoryEntryCombiner, squadExecutor, exceptionHandler);
        ContentsProcessor<T> cp = ContentsProcessings.recursiveCompressedAndArchiveContentsProcessor(lookIntoFormat, pathPredicate, archiveEntryCombiner, normalContentsProcessor, exceptionHandler);
        return ResourceProcessings.fromContentsProcessorAndFileProcessor(cp, fp);
    }

    public static <T> ResourceProcessor<T> fromContentsProcessorAndFileProcessor(final ContentsProcessor<T> delegateCp, final @Nullable FileProcessor<T> delegateFp) {
        return new ResourceProcessor<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public T process(String path, final URL location) throws IOException, InterruptedException {
                File file;
                if (location.equals(STDIN_URL)) {
                    final byte[] input = InputStreams.readAll((InputStream)System.in);
                    return delegateCp.process("-", new ByteArrayInputStream(input), new Date(), -1L, -1L, (ProducerWhichThrows<InputStream, IOException>)new ProducerWhichThrows<InputStream, IOException>(){

                        @Nullable
                        public InputStream produce() {
                            return new ByteArrayInputStream(input);
                        }
                    });
                }
                if (delegateFp != null && (file = ResourceProcessings.isFile(location)) != null) {
                    return delegateFp.process(path, file);
                }
                ProducerWhichThrows<InputStream, IOException> opener = new ProducerWhichThrows<InputStream, IOException>(){

                    @Nullable
                    public InputStream produce() throws IOException {
                        return location.openConnection().getInputStream();
                    }
                };
                URLConnection conn = location.openConnection();
                long size = -1L;
                long crc32 = -1L;
                if (conn instanceof JarURLConnection) {
                    JarURLConnection juc = (JarURLConnection)conn;
                    size = juc.getJarEntry().getSize();
                    crc32 = juc.getJarEntry().getCrc();
                } else if (conn instanceof HttpURLConnection) {
                    HttpURLConnection huc = (HttpURLConnection)conn;
                    size = huc.getContentLength();
                }
                long lastModified = conn.getLastModified();
                Date lastModifiedDate = lastModified == 0L ? null : new Date(lastModified);
                InputStream is = conn.getInputStream();
                Object result = delegateCp.process(path, is, lastModifiedDate, size, crc32, (ProducerWhichThrows<InputStream, IOException>)opener);
                is.close();
                Object t = result;
                return t;
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    public static URL toUrl(String filePathnameOrUrl) throws MalformedURLException {
        return LOOKS_LIKE_URL.matcher(filePathnameOrUrl).find() ? new URL(filePathnameOrUrl) : ("-".equals(filePathnameOrUrl) ? STDIN_URL : new File(filePathnameOrUrl).toURI().toURL());
    }

    private static URL stdinUrl() {
        try {
            return new URL("file", null, "-");
        }
        catch (MalformedURLException mue) {
            throw new ExceptionInInitializerError(mue);
        }
    }

    @Nullable
    public static File isFile(URL location) {
        URI uri;
        if (!location.getProtocol().equalsIgnoreCase("file")) {
            return null;
        }
        try {
            uri = location.toURI();
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        return new File(uri);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        STDIN_URL = ResourceProcessings.stdinUrl();
        LOOKS_LIKE_URL = Pattern.compile("^[A-Za-z0-9+\\-.]{2,}:");
    }
}

