/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.contentsprocessing;

import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class SelectiveContentsProcessor<T>
implements ContentsProcessor<T> {
    private final Predicate<? super String> pathPredicate;
    private final ContentsProcessor<T> trueDelegate;
    private final ContentsProcessor<T> falseDelegate;

    public SelectiveContentsProcessor(Predicate<? super String> pathPredicate, ContentsProcessor<T> trueDelegate, ContentsProcessor<T> falseDelegate) {
        this.pathPredicate = pathPredicate;
        this.trueDelegate = trueDelegate;
        this.falseDelegate = falseDelegate;
    }

    @Override
    @Nullable
    public T process(String path, InputStream is, @Nullable Date lastModifiedDate, long size, long crc32, ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) throws IOException {
        if (this.pathPredicate.evaluate((Object)path)) {
            return this.trueDelegate.process(path, is, lastModifiedDate, size, crc32, opener);
        }
        return this.falseDelegate.process(path, is, lastModifiedDate, size, crc32, opener);
    }
}

