/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.contentsprocessing;

import de.unkrig.commons.file.CompressUtil;
import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.contentsprocessing.SelectiveContentsProcessor;
import de.unkrig.commons.file.fileprocessing.FileProcessings;
import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.HardReference;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.util.concurrent.ConcurrentUtil;
import de.unkrig.commons.util.concurrent.SquadExecutor;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;

public final class ContentsProcessings {
    private static final ContentsProcessor<?> NOP_CONTENTS_PROCESSOR;
    private static final ArchiveCombiner<?> NOP_ARCHIVE_COMBINER;

    private ContentsProcessings() {
    }

    public static <T> ContentsProcessor<T> nopContentsProcessor() {
        return NOP_CONTENTS_PROCESSOR;
    }

    public static <T> ArchiveCombiner<T> nopArchiveCombiner() {
        return NOP_ARCHIVE_COMBINER;
    }

    @Nullable
    public static <T> T processArchive(String archivePath, ArchiveInputStream archiveInputStream, ContentsProcessor<T> contentsProcessor, ArchiveCombiner<T> entryCombiner, final ProducerWhichThrows<? extends ArchiveInputStream, ? extends IOException> archiveOpener, ExceptionHandler<IOException> exceptionHandler) throws IOException {
        ArrayList<T> combinables = new ArrayList<T>();
        ArchiveEntry ae = archiveInputStream.getNextEntry();
        while (ae != null) {
            if (!ae.isDirectory()) {
                final String entryName = ArchiveFormatFactory.normalizeEntryName(ae.getName());
                final String entryPath = archivePath + '!' + entryName;
                try {
                    Date lastModifiedDate;
                    ProducerWhichThrows<InputStream, IOException> opener = new ProducerWhichThrows<InputStream, IOException>(){

                        @Nullable
                        public InputStream produce() throws IOException {
                            ArchiveInputStream ais = (ArchiveInputStream)AssertionUtil.notNull((Object)((ArchiveInputStream)archiveOpener.produce()));
                            ArchiveEntry ae2 = ais.getNextEntry();
                            while (ae2 != null) {
                                String name2 = ArchiveFormatFactory.normalizeEntryName(ae2.getName());
                                if (name2.equals(entryName)) {
                                    return ais;
                                }
                                ae2 = ais.getNextEntry();
                            }
                            ais.close();
                            throw new IOException(entryPath);
                        }
                    };
                    long crc32 = ArchiveFormatFactory.getEntryCrc32(ae);
                    try {
                        lastModifiedDate = ae.getLastModifiedDate();
                    }
                    catch (UnsupportedOperationException uoe) {
                        lastModifiedDate = null;
                    }
                    combinables.add(contentsProcessor.process(entryPath, (InputStream)archiveInputStream, lastModifiedDate, ae.getSize(), crc32, opener));
                }
                catch (IOException ioe) {
                    exceptionHandler.handle(entryPath, ioe);
                }
                catch (RuntimeException re) {
                    exceptionHandler.handle(entryPath, re);
                }
            }
            ae = archiveInputStream.getNextEntry();
        }
        return entryCombiner.combine(archivePath, combinables);
    }

    public static <T> ContentsProcessor<T> compressedAndArchiveContentsProcessor(final Predicate<? super String> lookIntoFormat, Predicate<? super String> pathPredicate, final ContentsProcessor<T> archiveContentsProcessor, final ArchiveCombiner<T> archiveEntryCombiner, final ContentsProcessor<T> compressedContentsProcessor, final ContentsProcessor<T> normalContentsProcessor, final ExceptionHandler<IOException> exceptionHandler) {
        ContentsProcessor cp = new ContentsProcessor<T>(){

            @Override
            @Nullable
            public T process(String path, InputStream inputStream, @Nullable Date lastModifiedDate, long size, long crc32, ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) throws IOException {
                return CompressUtil.processStream(path, inputStream, lastModifiedDate, (Predicate<? super String>)lookIntoFormat, ContentsProcessings.archiveHandler(path, archiveContentsProcessor, archiveEntryCombiner, opener, exceptionHandler), ContentsProcessings.compressorHandler(path, compressedContentsProcessor, opener), ContentsProcessings.normalContentsHandler(path, normalContentsProcessor, size, crc32, opener));
            }

            public String toString() {
                return "compressedAndArchiveContentsProcessor";
            }
        };
        return ContentsProcessings.select(pathPredicate, cp);
    }

    public static <T> ContentsProcessor<T> select(Predicate<? super String> pathPredicate, ContentsProcessor<T> delegate) {
        return ContentsProcessings.select(pathPredicate, delegate, null);
    }

    public static <T> ContentsProcessor<T> select(Predicate<? super String> pathPredicate, ContentsProcessor<T> trueCp, @Nullable ContentsProcessor<T> falseCp) {
        if (falseCp == null) {
            falseCp = ContentsProcessings.nopContentsProcessor();
        }
        if (pathPredicate == PredicateUtil.always()) {
            return trueCp;
        }
        if (pathPredicate == PredicateUtil.never()) {
            return falseCp;
        }
        return new SelectiveContentsProcessor<T>(pathPredicate, trueCp, falseCp);
    }

    public static <T> ContentsProcessor<T> recursiveCompressedAndArchiveContentsProcessor(Predicate<? super String> lookIntoFormat, Predicate<? super String> pathPredicate, ArchiveCombiner<T> archiveEntryCombiner, ContentsProcessor<T> normalContentsProcessor, ExceptionHandler<IOException> exceptionHandler) {
        final HardReference loopback = new HardReference();
        ContentsProcessor tmp = new ContentsProcessor<T>(){

            @Override
            @Nullable
            public T process(String name, InputStream inputStream, @Nullable Date lastModifiedDate, long size, long crc32, ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) throws IOException {
                ContentsProcessor l = (ContentsProcessor)loopback.get();
                assert (l != null);
                return l.process(name, inputStream, lastModifiedDate, size, crc32, opener);
            }
        };
        ContentsProcessor<T> result = ContentsProcessings.compressedAndArchiveContentsProcessor(lookIntoFormat, pathPredicate, tmp, archiveEntryCombiner, tmp, normalContentsProcessor, exceptionHandler);
        loopback.set(result);
        return result;
    }

    public static <T> CompressUtil.ArchiveHandler<T> archiveHandler(final String path, final ContentsProcessor<T> contentsProcessor, final ArchiveCombiner<T> archiveEntryCombiner, final ProducerWhichThrows<? extends InputStream, ? extends IOException> opener, final ExceptionHandler<IOException> exceptionHandler) {
        return new CompressUtil.ArchiveHandler<T>(){

            @Override
            @Nullable
            public T handleArchive(ArchiveInputStream archiveInputStream, final ArchiveFormat archiveFormat) throws IOException {
                return ContentsProcessings.processArchive(path, archiveInputStream, contentsProcessor, archiveEntryCombiner, (ProducerWhichThrows<? extends ArchiveInputStream, ? extends IOException>)new ProducerWhichThrows<ArchiveInputStream, IOException>(){

                    @Nullable
                    public ArchiveInputStream produce() throws IOException {
                        try {
                            InputStream is = (InputStream)opener.produce();
                            assert (is != null);
                            return archiveFormat.archiveInputStream(is);
                        }
                        catch (ArchiveException ae) {
                            throw (IOException)ExceptionUtil.wrap(null, (Throwable)ae, IOException.class);
                        }
                    }
                }, exceptionHandler);
            }
        };
    }

    public static <T> CompressUtil.CompressorHandler<T> compressorHandler(final String path, final ContentsProcessor<T> contentsProcessor, final ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) {
        return new CompressUtil.CompressorHandler<T>(){

            @Override
            @Nullable
            public T handleCompressor(CompressorInputStream compressorInputStream, final CompressionFormat compressionFormat) throws IOException {
                long size = CompressionFormatFactory.getUncompressedSize(compressorInputStream);
                try {
                    return contentsProcessor.process(path + '%', (InputStream)compressorInputStream, null, size, -1L, (ProducerWhichThrows<InputStream, IOException>)new ProducerWhichThrows<InputStream, IOException>(){

                        @Nullable
                        public InputStream produce() throws IOException {
                            return compressionFormat.compressorInputStream((InputStream)AssertionUtil.notNull((Object)((InputStream)opener.produce())));
                        }
                    });
                }
                catch (EOFException eofe) {
                    if ("gz".equals(compressionFormat.getName())) {
                        eofe = (EOFException)ExceptionUtil.wrap((String)"Maybe a \"normal\" file was accidentially detected as gzip-compressed; consider using \"--look-into '~gz:***'\"", (Throwable)eofe);
                    }
                    throw eofe;
                }
            }
        };
    }

    public static <T> CompressUtil.NormalContentsHandler<T> normalContentsHandler(final String path, final ContentsProcessor<T> contentsProcessor, final long size, final long crc32, final ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) {
        return new CompressUtil.NormalContentsHandler<T>(){

            @Override
            @Nullable
            public T handleNormalContents(InputStream inputStream, @Nullable Date lastModifiedDate) throws IOException {
                return contentsProcessor.process(path, inputStream, lastModifiedDate, size, crc32, (ProducerWhichThrows<InputStream, IOException>)opener);
            }
        };
    }

    public static void glob(Pattern pattern, ContentsProcessor<Void> cp) throws IOException, InterruptedException {
        File sf = FileProcessings.starterFile(pattern.pattern().replace("[/\\\\]", "/"));
        Glob pathPredicate = Glob.compileRegex((Pattern)pattern);
        FileProcessor<Void> fp = FileProcessings.recursiveCompressedAndArchiveFileProcessor((Predicate<? super String>)PredicateUtil.always(), (Predicate<? super String>)pathPredicate, ContentsProcessings.nopArchiveCombiner(), new SelectiveContentsProcessor<Void>((Predicate<? super String>)pathPredicate, cp, ContentsProcessings.nopContentsProcessor()), ExceptionHandler.defaultHandler());
        fp = FileProcessings.directoryTreeProcessor((Predicate<? super String>)pathPredicate, fp, Collator.getInstance(), FileProcessings.nopDirectoryCombiner(), false, new SquadExecutor(ConcurrentUtil.SEQUENTIAL_EXECUTOR_SERVICE), ExceptionHandler.defaultHandler());
        if (sf != null) {
            fp.process(sf.getPath(), sf);
        } else {
            fp.process("", new File("."));
        }
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        NOP_CONTENTS_PROCESSOR = new ContentsProcessor<Object>(){

            @Override
            @Nullable
            public Object process(String path, InputStream inputStream, @Nullable Date lastModifiedDate, long size, long crc32, ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) {
                return null;
            }
        };
        NOP_ARCHIVE_COMBINER = new ArchiveCombiner<Object>(){

            @Override
            @Nullable
            public Object combine(String archivePath, List<Object> combinables) {
                return null;
            }
        };
    }

    public static interface ArchiveCombiner<T> {
        @Nullable
        public T combine(String var1, List<T> var2);
    }
}

