/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.dump;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.AbstractArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.compressors.FileNameUtil;

public final class DumpArchiveFormat
extends AbstractArchiveFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(Collections.singletonMap(".dump", ""), ".dump");
    private static final ArchiveFormat INSTANCE = new DumpArchiveFormat();

    private DumpArchiveFormat() {
    }

    public static ArchiveFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "dump";
    }

    @Override
    public boolean isArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public ArchiveInputStream archiveInputStream(InputStream is) throws ArchiveException {
        return new DumpArchiveInputStream(is);
    }

    @Override
    public ArchiveOutputStream archiveOutputStream(OutputStream os) throws ArchiveException {
        throw new ArchiveException("Creation of 'dump' archives not supported");
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return DumpArchiveInputStream.matches((byte[])signature, (int)signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

