/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.ar;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.AbstractArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.OutputStreams;
import de.unkrig.commons.io.pipe.Pipe;
import de.unkrig.commons.io.pipe.PipeFactory;
import de.unkrig.commons.io.pipe.PipeUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.MapUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.compressors.FileNameUtil;

public final class ArArchiveFormat
extends AbstractArchiveFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(MapUtil.map((Object[])new Object[]{".a", "", ".ar", ""}), ".a");
    private static final ArchiveFormat INSTANCE = new ArArchiveFormat();

    private ArArchiveFormat() {
    }

    public static ArchiveFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "ar";
    }

    @Override
    public boolean isArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public ArchiveInputStream archiveInputStream(InputStream is) {
        final ArArchiveInputStream aais = new ArArchiveInputStream(is);
        return new ArchiveInputStream(){

            @Nullable
            public ArchiveEntry getNextEntry() throws IOException {
                ArArchiveEntry aae = this.getNextEntry2(aais);
                if (aae != null && aae.getName().isEmpty()) {
                    aae = new ArArchiveEntry("__ROOT", aae.getLength(), aae.getUserId(), aae.getGroupId(), aae.getMode(), aae.getLastModified());
                }
                return aae;
            }

            @Nullable
            private ArArchiveEntry getNextEntry2(ArArchiveInputStream aais2) throws IOException {
                try {
                    return this.getNextEntry3(aais2);
                }
                catch (NumberFormatException nfe) {
                    if (nfe.getStackTrace()[2].getClassName().equals("org.apache.commons.compress.archivers.ar.ArArchiveInputStream")) {
                        throw (IOException)ExceptionUtil.wrap((String)"Corrupt AR entry", (Throwable)nfe, IOException.class);
                    }
                    throw nfe;
                }
            }

            @Nullable
            private ArArchiveEntry getNextEntry3(ArArchiveInputStream aais2) throws IOException {
                return aais2.getNextArEntry();
            }

            public void close() throws IOException {
                aais.close();
            }

            @NotNullByDefault(value=false)
            public int read(byte[] b, int off, int len) throws IOException {
                return aais.read(b, off, len);
            }
        };
    }

    @Override
    public ArchiveOutputStream archiveOutputStream(OutputStream os) {
        ArArchiveOutputStream aaos = new ArArchiveOutputStream(os);
        aaos.setLongFileMode(1);
        return aaos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, String name, @Nullable Date lastModifiedDate, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (!(archiveOutputStream instanceof ArArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        PipeUtil.InputOutputStreams ios = PipeUtil.asInputOutputStreams((Pipe)PipeFactory.elasticPipe());
        try {
            long count = OutputStreams.writeAndCount(writeContents, (OutputStream)ios.getOutputStream());
            ios.getOutputStream().close();
            archiveOutputStream.putArchiveEntry((ArchiveEntry)new ArArchiveEntry(name, count, 0, 0, 33188, (lastModifiedDate != null ? lastModifiedDate.getTime() : System.currentTimeMillis()) / 1000L));
            IoUtil.copy((InputStream)ios.getInputStream(), (OutputStream)archiveOutputStream);
            ios.getInputStream().close();
            archiveOutputStream.closeArchiveEntry();
        }
        finally {
            try {
                ios.getOutputStream().close();
            }
            catch (Exception exception) {}
            try {
                ios.getInputStream().close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void writeDirectoryEntry(ArchiveOutputStream archiveOutputStream, String name) {
        if (!(archiveOutputStream instanceof ArArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        throw new UnsupportedOperationException("The AR archive format does not support directory entries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, ArchiveEntry archiveEntry, @Nullable String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        ArArchiveEntry aae;
        if (!(archiveOutputStream instanceof ArArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        ArArchiveEntry arArchiveEntry = aae = archiveEntry instanceof ArArchiveEntry ? (ArArchiveEntry)archiveEntry : new ArArchiveEntry("", 0L);
        if (archiveEntry.isDirectory()) {
            return;
        }
        PipeUtil.InputOutputStreams ios = PipeUtil.asInputOutputStreams((Pipe)PipeFactory.elasticPipe());
        try {
            long lastModified;
            long count = OutputStreams.writeAndCount(writeContents, (OutputStream)ios.getOutputStream());
            ios.getOutputStream().close();
            try {
                lastModified = archiveEntry.getLastModifiedDate().getTime();
            }
            catch (UnsupportedOperationException uoe) {
                lastModified = 0L;
            }
            ArArchiveEntry naae = new ArArchiveEntry(name != null ? name : archiveEntry.getName(), count, aae.getUserId(), aae.getGroupId(), aae.getMode(), lastModified / 1000L);
            archiveOutputStream.putArchiveEntry((ArchiveEntry)naae);
            IoUtil.copy((InputStream)ios.getInputStream(), (OutputStream)archiveOutputStream);
            ios.getInputStream().close();
            archiveOutputStream.closeArchiveEntry();
        }
        finally {
            try {
                ios.getOutputStream().close();
            }
            catch (Exception exception) {}
            try {
                ios.getInputStream().close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return ArArchiveInputStream.matches((byte[])signature, (int)signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

