/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;

public abstract class AbstractArchiveFormat
implements ArchiveFormat {
    @Override
    public ArchiveInputStream archiveInputStream(InputStream is) throws StreamingNotSupportedException, ArchiveException {
        throw new StreamingNotSupportedException(this.getName());
    }

    @Override
    public ArchiveInputStream open(File archiveFile) throws IOException, StreamingNotSupportedException, ArchiveException {
        return this.archiveInputStream(new BufferedInputStream(new FileInputStream(archiveFile)));
    }

    @Override
    public ArchiveOutputStream archiveOutputStream(OutputStream os) throws StreamingNotSupportedException, ArchiveException {
        throw new StreamingNotSupportedException(this.getName());
    }

    @Override
    public ArchiveOutputStream create(File archiveFile) throws IOException, ArchiveException {
        throw new ArchiveException("Creation of \"" + this.getName() + "\" archives not supported");
    }

    @Override
    public final void writeEntry(ArchiveOutputStream archiveOutputStream, String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        this.writeEntry(archiveOutputStream, name, null, writeContents);
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, String name, @Nullable Date lastModifiedDate, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
    }

    @Override
    public void writeDirectoryEntry(ArchiveOutputStream archiveOutputStream, String name) throws IOException {
        throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, ArchiveEntry archiveEntry, @Nullable String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
    }

    @Override
    @Nullable
    public String getCompressionMethod(ArchiveEntry ae) {
        return null;
    }
}

