/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.fileprocessing;

import de.unkrig.commons.file.CompressUtil;
import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessings;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.file.fileprocessing.SelectiveFileProcessor;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.HardReference;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.text.pattern.PatternUtil;
import de.unkrig.commons.util.concurrent.ConcurrentUtil;
import de.unkrig.commons.util.concurrent.SquadExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;

public final class FileProcessings {
    private static final Logger LOGGER;
    private static final FileProcessor<?> NOP_FILE_PROCESSOR;
    private static final DirectoryCombiner<?> NOP_DIRECTORY_COMBINER;

    private FileProcessings() {
    }

    public static <T> FileProcessor<T> nop() {
        return NOP_FILE_PROCESSOR;
    }

    public static <T> void process(List<File> files, FileProcessor<T> fileProcessor) throws IOException, InterruptedException {
        FileProcessings.process(files, fileProcessor, ExceptionHandler.defaultHandler());
    }

    public static <T> void process(List<File> files, FileProcessor<T> fileProcessor, ExceptionHandler<IOException> exceptionHandler) throws IOException, InterruptedException {
        for (File file : files) {
            String path = file.getPath();
            try {
                fileProcessor.process(path, file);
            }
            catch (IOException ioe) {
                exceptionHandler.handle(path, ioe);
            }
            catch (RuntimeException re) {
                exceptionHandler.handle(path, re);
            }
        }
    }

    public static <T> FileProcessor<T> directoryTreeProcessor(Predicate<? super String> pathPredicate, FileProcessor<T> regularFileProcessor, @Nullable Comparator<? super String> directoryMemberNameComparator, DirectoryCombiner<T> directoryCombiner, SquadExecutor<T> squadExecutor, ExceptionHandler<IOException> exceptionHandler) {
        return FileProcessings.directoryTreeProcessor(pathPredicate, regularFileProcessor, directoryMemberNameComparator, directoryCombiner, false, squadExecutor, exceptionHandler);
    }

    public static <T> FileProcessor<T> directoryTreeProcessor(Predicate<? super String> pathPredicate, FileProcessor<T> regularFileProcessor, @Nullable Comparator<? super String> directoryMemberNameComparator, DirectoryCombiner<T> directoryCombiner, boolean includeDirs, SquadExecutor<T> squadExecutor, ExceptionHandler<IOException> exceptionHandler) {
        final HardReference loopback = new HardReference();
        FileProcessor directoryMemberProcessor = new FileProcessor<T>(){

            @Override
            @Nullable
            public T process(String path, File file) throws IOException, InterruptedException {
                FileProcessor fp = (FileProcessor)loopback.get();
                assert (fp != null);
                return fp.process(path, file);
            }
        };
        FileProcessor<T> result = FileProcessings.directoryProcessor(pathPredicate, regularFileProcessor, directoryMemberNameComparator, directoryMemberProcessor, directoryCombiner, includeDirs, squadExecutor, exceptionHandler);
        loopback.set(result);
        return result;
    }

    public static <T> FileProcessor<T> directoryProcessor(Predicate<? super String> pathPredicate, FileProcessor<T> regularFileProcessor, @Nullable Comparator<? super String> directoryMemberNameComparator, FileProcessor<T> directoryMemberProcessor, DirectoryCombiner<T> directoryCombiner, SquadExecutor<T> squadExecutor, ExceptionHandler<IOException> exceptionHandler) {
        return FileProcessings.directoryProcessor(pathPredicate, regularFileProcessor, directoryMemberNameComparator, directoryMemberProcessor, directoryCombiner, false, squadExecutor, exceptionHandler);
    }

    public static <T> FileProcessor<T> directoryProcessor(final Predicate<? super String> pathPredicate, final FileProcessor<T> regularFileProcessor, final @Nullable Comparator<? super String> directoryMemberNameComparator, final FileProcessor<T> directoryMemberProcessor, final DirectoryCombiner<T> directoryCombiner, final boolean includeDirs, final SquadExecutor<T> squadExecutor, final ExceptionHandler<IOException> exceptionHandler) {
        final FileProcessor directoryProcessor = new FileProcessor<T>(){

            @Override
            @Nullable
            public T process(final String directoryPath, final File directory) throws IOException, InterruptedException {
                LOGGER.log(Level.FINER, "Processing directory \"{0}\" (path is \"{1}\")", new Object[]{directory, directoryPath});
                String[] memberNames = directory.list();
                if (memberNames == null) {
                    throw new IOException("'" + directory + "' is not a listable directory");
                }
                if (directoryMemberNameComparator != null) {
                    Arrays.sort(memberNames, directoryMemberNameComparator);
                }
                ArrayList<Future> futures = new ArrayList<Future>(memberNames.length);
                for (String mn : memberNames) {
                    final String memberName = mn.replace('\uf031', ':');
                    futures.add(squadExecutor.submit(new Callable<T>(){

                        @Override
                        @Nullable
                        public T call() throws IOException, InterruptedException {
                            String memberPath = directoryPath + File.separatorChar + memberName;
                            try {
                                return directoryMemberProcessor.process(memberPath, new File(directory, memberName));
                            }
                            catch (IOException ioe) {
                                exceptionHandler.handle(memberPath, ioe);
                            }
                            catch (RuntimeException re) {
                                exceptionHandler.handle(memberPath, re);
                            }
                            return null;
                        }
                    }));
                }
                ArrayList combinables = new ArrayList(memberNames.length);
                for (Future future : futures) {
                    try {
                        combinables.add(future.get());
                    }
                    catch (ExecutionException ee) {
                        Throwable cause = ee.getCause();
                        if (cause instanceof IOException) {
                            throw (IOException)cause;
                        }
                        throw new IllegalStateException(ee);
                    }
                }
                return directoryCombiner.combine(directoryPath, directory, combinables);
            }
        };
        return new FileProcessor<T>(){

            @Override
            @Nullable
            public T process(String path, File file) throws IOException, InterruptedException {
                if (file.isDirectory()) {
                    if (includeDirs) {
                        regularFileProcessor.process(path, file);
                    }
                    return pathPredicate.evaluate((Object)(path + '/')) ? (Object)directoryProcessor.process(path, file) : null;
                }
                return regularFileProcessor.process(path, file);
            }
        };
    }

    public static <T> DirectoryCombiner<T> nopDirectoryCombiner() {
        return NOP_DIRECTORY_COMBINER;
    }

    @Deprecated
    public static <T> FileProcessor<T> archiveCompressedAndNormalFileProcessor(Predicate<? super String> lookIntoFormat, ContentsProcessor<T> archiveContentsProcessor, ContentsProcessings.ArchiveCombiner<T> archiveEntryCombiner, ContentsProcessor<T> compressedContentsProcessor, ContentsProcessor<T> normalContentsProcessor, ExceptionHandler<IOException> exceptionHandler) {
        return FileProcessings.compressedAndArchiveFileProcessor(lookIntoFormat, (Predicate<? super String>)PredicateUtil.always(), archiveContentsProcessor, archiveEntryCombiner, compressedContentsProcessor, normalContentsProcessor, exceptionHandler);
    }

    public static <T> FileProcessor<T> compressedAndArchiveFileProcessor(final Predicate<? super String> lookIntoFormat, Predicate<? super String> pathPredicate, final ContentsProcessor<T> archiveContentsProcessor, final ContentsProcessings.ArchiveCombiner<T> archiveEntryCombiner, final ContentsProcessor<T> compressedContentsProcessor, final ContentsProcessor<T> normalContentsProcessor, final ExceptionHandler<IOException> exceptionHandler) {
        return FileProcessings.select(pathPredicate, new FileProcessor<T>(){

            @Override
            @Nullable
            public T process(String path, File file) throws FileNotFoundException, IOException {
                return CompressUtil.processFile(path, file, (Predicate<? super String>)lookIntoFormat, FileProcessings.archiveHandler(path, archiveContentsProcessor, archiveEntryCombiner, file, exceptionHandler), FileProcessings.compressorHandler(path, compressedContentsProcessor, file), FileProcessings.normalContentsHandler(path, normalContentsProcessor, file));
            }

            public String toString() {
                return "compressedAndArchiveFileProcessor";
            }
        });
    }

    public static <T> FileProcessor<T> select(Predicate<? super String> pathPredicate, FileProcessor<T> delegate) {
        return FileProcessings.select(pathPredicate, delegate, null);
    }

    public static <T> FileProcessor<T> select(Predicate<? super String> pathPredicate, FileProcessor<T> trueFp, @Nullable FileProcessor<T> falseFp) {
        if (falseFp == null) {
            falseFp = FileProcessings.nop();
        }
        if (pathPredicate == PredicateUtil.always()) {
            return trueFp;
        }
        if (pathPredicate == PredicateUtil.never()) {
            return falseFp;
        }
        return new SelectiveFileProcessor<T>(pathPredicate, trueFp, falseFp);
    }

    public static <T> FileProcessor<T> recursiveCompressedAndArchiveFileProcessor(Predicate<? super String> lookIntoFormat, Predicate<? super String> pathPredicate, ContentsProcessings.ArchiveCombiner<T> archiveEntryCombiner, ContentsProcessor<T> delegate, ExceptionHandler<IOException> exceptionHandler) {
        ContentsProcessor<T> tmp = ContentsProcessings.recursiveCompressedAndArchiveContentsProcessor(lookIntoFormat, pathPredicate, archiveEntryCombiner, delegate, exceptionHandler);
        return FileProcessings.archiveCompressedAndNormalFileProcessor(lookIntoFormat, tmp, archiveEntryCombiner, tmp, delegate, exceptionHandler);
    }

    private static <T> CompressUtil.ArchiveHandler<T> archiveHandler(final String path, final ContentsProcessor<T> contentsProcessor, final ContentsProcessings.ArchiveCombiner<T> archiveEntryCombiner, final File archiveFile, final ExceptionHandler<IOException> exceptionHandler) {
        return new CompressUtil.ArchiveHandler<T>(){

            @Override
            @Nullable
            public T handleArchive(ArchiveInputStream archiveInputStream, final ArchiveFormat archiveFormat) throws IOException {
                return ContentsProcessings.processArchive(path, archiveInputStream, contentsProcessor, archiveEntryCombiner, (ProducerWhichThrows<? extends ArchiveInputStream, ? extends IOException>)new ProducerWhichThrows<ArchiveInputStream, IOException>(){

                    @Nullable
                    public ArchiveInputStream produce() throws IOException {
                        try {
                            return archiveFormat.open(archiveFile);
                        }
                        catch (ArchiveException ae) {
                            throw (IOException)ExceptionUtil.wrap(null, (Throwable)ae, IOException.class);
                        }
                    }
                }, exceptionHandler);
            }
        };
    }

    private static <T> CompressUtil.CompressorHandler<T> compressorHandler(final String path, final ContentsProcessor<T> contentsProcessor, final File compressedFile) {
        return new CompressUtil.CompressorHandler<T>(){

            @Override
            @Nullable
            public T handleCompressor(CompressorInputStream compressorInputStream, final CompressionFormat compressionFormat) throws IOException {
                long uncompressedSize = CompressionFormatFactory.getUncompressedSize(compressorInputStream);
                return contentsProcessor.process(path + '%', (InputStream)compressorInputStream, null, uncompressedSize, -1L, (ProducerWhichThrows<InputStream, IOException>)new ProducerWhichThrows<InputStream, IOException>(){

                    @Nullable
                    public InputStream produce() throws IOException {
                        return compressionFormat.open(compressedFile);
                    }
                });
            }
        };
    }

    private static <T> CompressUtil.NormalContentsHandler<T> normalContentsHandler(final String path, final ContentsProcessor<T> contentsProcessor, final File normalFile) {
        return new CompressUtil.NormalContentsHandler<T>(){

            @Override
            @Nullable
            public T handleNormalContents(InputStream inputStream, @Nullable Date lastModifiedDate) throws IOException {
                return contentsProcessor.process(path, inputStream, lastModifiedDate, -1L, -1L, (ProducerWhichThrows<InputStream, IOException>)new ProducerWhichThrows<InputStream, IOException>(){

                    @Nullable
                    public InputStream produce() throws IOException {
                        return new FileInputStream(normalFile);
                    }
                });
            }
        };
    }

    @Nullable
    public static File starterFile(String regex) {
        String[] sa = PatternUtil.constantPrefix((String)regex);
        String prefix = sa[0];
        String suffix = sa[1];
        int idx = prefix.indexOf(33);
        if (idx != -1) {
            return new File(prefix.substring(0, idx));
        }
        if (suffix.isEmpty()) {
            return new File(prefix);
        }
        idx = Math.max(prefix.lastIndexOf(47), prefix.lastIndexOf(File.separatorChar));
        if (idx != -1) {
            return new File(prefix.substring(0, idx));
        }
        return null;
    }

    public static void glob(Pattern pattern, FileProcessor<Void> fp) throws IOException, InterruptedException {
        File sf = FileProcessings.starterFile(pattern.pattern().replace("[/\\\\]", "/"));
        if (sf != null) {
            Glob pathPredicate = Glob.compileRegex((Pattern)pattern);
            FileProcessings.directoryTreeProcessor((Predicate<? super String>)pathPredicate, new SelectiveFileProcessor<Void>((Predicate<? super String>)pathPredicate, fp, FileProcessings.nop()), Collator.getInstance(), FileProcessings.nopDirectoryCombiner(), true, new SquadExecutor(ConcurrentUtil.SEQUENTIAL_EXECUTOR_SERVICE), ExceptionHandler.defaultHandler()).process(sf.getPath(), sf);
        }
    }

    public static List<File> glob(Pattern pattern) throws IOException, InterruptedException {
        final ArrayList<File> files = new ArrayList<File>();
        FileProcessings.glob(pattern, new FileProcessor<Void>(){

            @Override
            @Nullable
            public Void process(String path, File file) {
                files.add(file);
                return null;
            }
        });
        return files;
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        LOGGER = Logger.getLogger(FileProcessings.class.getName());
        NOP_FILE_PROCESSOR = new FileProcessor<Object>(){

            @Override
            @Nullable
            public Object process(String path, File in) {
                return null;
            }

            public String toString() {
                return "NOP";
            }
        };
        NOP_DIRECTORY_COMBINER = new DirectoryCombiner<Object>(){

            @Override
            @Nullable
            public Object combine(String directoryPath, File directory, List<Object> combinables) {
                return null;
            }
        };
    }

    public static interface DirectoryCombiner<T> {
        @Nullable
        public T combine(String var1, File var2, List<T> var3);
    }
}

