/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public final class FileUtil {
    private FileUtil() {
    }

    public static boolean attemptToDeleteRecursively(File file) {
        if (file.isDirectory()) {
            boolean success = true;
            File[] members = file.listFiles();
            if (members == null) {
                return false;
            }
            for (File member : members) {
                success &= FileUtil.attemptToDeleteRecursively(member);
            }
            if (!success) {
                return false;
            }
        }
        return file.delete();
    }

    public static void deleteRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            File[] members = file.listFiles();
            if (members == null) {
                throw new IOException(file + ": Permission denied");
            }
            for (File member : members) {
                FileUtil.deleteRecursively(member);
            }
        }
        if (!file.delete()) {
            throw new IOException("Cannot delete '" + file + "'");
        }
    }

    public static void rename(File oldFile, File newFile) throws IOException {
        if (!oldFile.renameTo(newFile)) {
            throw new IOException("Could not rename '" + oldFile + "' to '" + newFile + "'");
        }
    }

    public static <EX extends Throwable> void processContent(File file, Charset charset, ConsumerWhichThrows<? super Reader, ? extends EX> processor) throws IOException, EX {
        FileUtil.processContent(new InputStreamReader((InputStream)new FileInputStream(file), charset), processor);
    }

    public static <EX extends Throwable> void processContent(Reader reader, ConsumerWhichThrows<? super Reader, ? extends EX> processor) throws IOException, EX {
        try {
            processor.consume((Object)reader);
            reader.close();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public static ProducerWhichThrows<FileInputStream, IOException> opener(final File file) {
        return new ProducerWhichThrows<FileInputStream, IOException>(){

            @Nullable
            public FileInputStream produce() throws IOException {
                return new FileInputStream(file);
            }
        };
    }

    public static ProducerWhichThrows<ByteArrayInputStream, IOException> opener(final byte[] data) {
        return new ProducerWhichThrows<ByteArrayInputStream, IOException>(){

            @Nullable
            public ByteArrayInputStream produce() {
                return new ByteArrayInputStream(data);
            }
        };
    }
}

