/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.rpm;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.AbstractArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.lang.ExceptionUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.compressors.FileNameUtil;
import org.redline_rpm.ReadableChannelWrapper;
import org.redline_rpm.Util;
import org.redline_rpm.header.Header;
import org.redline_rpm.header.Lead;
import org.redline_rpm.header.Signature;

public final class RpmArchiveFormat
extends AbstractArchiveFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(Collections.singletonMap(".rpm", ""), ".rpm");
    private static final ArchiveFormat INSTANCE = new RpmArchiveFormat();

    private RpmArchiveFormat() {
    }

    public static ArchiveFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "rpm";
    }

    @Override
    public boolean isArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public ArchiveInputStream archiveInputStream(InputStream is) throws ArchiveException {
        try {
            return RpmArchiveFormat.archiveInputStream2(is);
        }
        catch (IOException ioe) {
            throw (ArchiveException)ExceptionUtil.wrap(null, (Throwable)ioe, ArchiveException.class);
        }
    }

    static CpioArchiveInputStream archiveInputStream2(InputStream is) throws IOException {
        ReadableChannelWrapper in = new ReadableChannelWrapper(Channels.newChannel(is));
        new Lead().read((ReadableByteChannel)in);
        new Signature().read((ReadableByteChannel)in);
        Header header = new Header();
        header.read((ReadableByteChannel)in);
        return new CpioArchiveInputStream(Util.openPayloadStream((Header)header, (InputStream)is));
    }

    @Override
    public ArchiveInputStream open(File archiveFile) throws IOException {
        return RpmArchiveFormat.archiveInputStream2(new BufferedInputStream(new FileInputStream(archiveFile)));
    }

    @Override
    public ArchiveOutputStream archiveOutputStream(OutputStream os) throws ArchiveException {
        throw new ArchiveException("Creation of 'rpm' archives not supported");
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return signatureLength >= 4 && (0xFF & signature[0]) == 237 && (0xFF & signature[1]) == 171 && (0xFF & signature[2]) == 238 && (0xFF & signature[3]) == 219;
    }

    public String toString() {
        return this.getName();
    }
}

