/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.contentstransformation;

import de.unkrig.commons.file.contentstransformation.ContentsTransformations;
import de.unkrig.commons.file.contentstransformation.ContentsTransformer;
import de.unkrig.commons.file.contentstransformation.ContentsTransformerByteFilter;
import de.unkrig.commons.io.ByteFilter;
import de.unkrig.commons.io.ByteFilterInputStream;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SelectiveContentsTransformer
implements ContentsTransformer {
    private final Predicate<? super String> pathPredicate;
    private final ContentsTransformer transformer;
    private final ContentsTransformer delegate;

    public static ContentsTransformer create(Predicate<? super String> pathPredicate, ContentsTransformer transformer, ContentsTransformer delegate) {
        if (pathPredicate == PredicateUtil.always()) {
            return ContentsTransformations.chain(transformer, delegate);
        }
        if (pathPredicate == PredicateUtil.never()) {
            return delegate;
        }
        if (transformer == ContentsTransformations.COPY) {
            return delegate;
        }
        return new SelectiveContentsTransformer(pathPredicate, transformer, delegate);
    }

    public SelectiveContentsTransformer(Predicate<? super String> pathPredicate, ContentsTransformer transformer, ContentsTransformer delegate) {
        this.pathPredicate = pathPredicate;
        this.transformer = transformer;
        this.delegate = delegate;
    }

    @Override
    public void transform(String path, InputStream is, OutputStream os) throws IOException {
        if (!this.pathPredicate.evaluate((Object)path)) {
            this.delegate.transform(path, is, os);
            return;
        }
        if (this.delegate == ContentsTransformations.COPY) {
            this.transformer.transform(path, is, os);
            return;
        }
        if (this.transformer == ContentsTransformations.COPY) {
            this.delegate.transform(path, is, os);
            return;
        }
        this.delegate.transform(path, (InputStream)new ByteFilterInputStream(is, (ByteFilter)new ContentsTransformerByteFilter(this.transformer, path)), os);
    }

    public String toString() {
        return "(" + this.pathPredicate + " ? " + this.delegate + " => " + this.transformer + " : " + this.delegate + ")";
    }
}

