/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.compressors.snappy;

import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;

public final class FramedSnappyCompressionFormat
implements CompressionFormat {
    private static final CompressionFormat INSTANCE = new FramedSnappyCompressionFormat();

    private FramedSnappyCompressionFormat() {
    }

    public static CompressionFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "snappy-framed";
    }

    @Override
    public boolean isCompressedFileName(String fileName) {
        return false;
    }

    @Override
    public String getCompressedFileName(String fileName) {
        return fileName;
    }

    @Override
    public String getUncompressedFileName(String fileName) {
        return fileName;
    }

    @Override
    public CompressorInputStream compressorInputStream(InputStream is) throws IOException {
        return new FramedSnappyCompressorInputStream(is);
    }

    @Override
    public CompressorInputStream open(File compressedFile) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(compressedFile));
        try {
            return new FramedSnappyCompressorInputStream((InputStream)is);
        }
        catch (IOException ioe) {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioe;
        }
    }

    @Override
    public CompressorOutputStream compressorOutputStream(OutputStream os) throws CompressorException {
        throw new CompressorException("Creation of 'framed snappy' compressed contents is not supported");
    }

    @Override
    public CompressorOutputStream create(File compressedFile) throws CompressorException {
        throw new CompressorException("Creation of 'framed snappy' compressed files is not supported");
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return FramedSnappyCompressorInputStream.matches((byte[])signature, (int)signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

