/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.zip;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.AbstractArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.FileNameUtil;

public final class ZipArchiveFormat
extends AbstractArchiveFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(Collections.singletonMap(".zip", ""), ".zip");
    private static final ArchiveFormat INSTANCE = new ZipArchiveFormat();

    private ZipArchiveFormat() {
    }

    public static ArchiveFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "zip";
    }

    @Override
    public boolean isArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public ArchiveInputStream archiveInputStream(InputStream is) {
        return new ZipArchiveInputStream(is);
    }

    @Override
    public ArchiveInputStream open(File archiveFile) throws IOException {
        return ZipArchiveFormat.zipArchiveInputStream(archiveFile);
    }

    @Override
    public ArchiveOutputStream archiveOutputStream(OutputStream os) {
        return new ZipArchiveOutputStream(os);
    }

    @Override
    public ArchiveOutputStream create(File archiveFile) throws IOException {
        return new ZipArchiveOutputStream(archiveFile);
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, String name, @Nullable Date lastModifiedDate, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (!(archiveOutputStream instanceof ZipArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        while (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        ZipArchiveEntry zae = new ZipArchiveEntry(name);
        if (lastModifiedDate != null) {
            zae.setTime(lastModifiedDate.getTime());
        }
        archiveOutputStream.putArchiveEntry((ArchiveEntry)zae);
        writeContents.consume((Object)archiveOutputStream);
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public void writeDirectoryEntry(ArchiveOutputStream archiveOutputStream, String name) throws IOException {
        if (!(archiveOutputStream instanceof ZipArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        if (!name.endsWith("/")) {
            name = name + '/';
        }
        archiveOutputStream.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(name));
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, ArchiveEntry archiveEntry, @Nullable String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (!(archiveOutputStream instanceof ZipArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        ZipArchiveEntry nzae = new ZipArchiveEntry(name != null ? name : archiveEntry.getName());
        try {
            nzae.setTime(archiveEntry.getLastModifiedDate().getTime());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (archiveEntry instanceof ZipArchiveEntry) {
            ZipArchiveEntry zae = (ZipArchiveEntry)archiveEntry;
            nzae.setComment(zae.getComment());
            nzae.setExternalAttributes(zae.getExternalAttributes());
            nzae.setExtraFields(zae.getExtraFields(true));
            nzae.setGeneralPurposeBit(zae.getGeneralPurposeBit());
            nzae.setInternalAttributes(zae.getInternalAttributes());
            nzae.setMethod(zae.getMethod());
            if (nzae.isDirectory()) {
                nzae.setSize(0L);
                nzae.setCrc(0L);
            }
        }
        if (nzae.getMethod() == 0) {
            nzae.setMethod(8);
        }
        archiveOutputStream.putArchiveEntry((ArchiveEntry)nzae);
        if (!archiveEntry.isDirectory()) {
            writeContents.consume((Object)archiveOutputStream);
        }
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return ZipArchiveInputStream.matches((byte[])signature, (int)signatureLength);
    }

    private static ArchiveInputStream zipArchiveInputStream(final File file) throws IOException {
        return new ArchiveInputStream(){
            final ZipFile zipFile;
            final Enumeration<ZipArchiveEntry> entries;
            @Nullable
            private InputStream stream;
            {
                this.zipFile = new ZipFile(file);
                this.entries = this.zipFile.getEntriesInPhysicalOrder();
            }

            public int getCount() {
                throw new UnsupportedOperationException("getCount");
            }

            public long getBytesRead() {
                throw new UnsupportedOperationException("getBytesRead");
            }

            public int read(@Nullable byte[] b, int off, int len) throws IOException {
                InputStream is = this.stream;
                if (is == null) {
                    throw new IllegalStateException();
                }
                return is.read(b, off, len);
            }

            public void close() throws IOException {
                this.zipFile.close();
            }

            @Nullable
            public ArchiveEntry getNextEntry() throws IOException {
                if (!this.entries.hasMoreElements()) {
                    this.stream = null;
                    return null;
                }
                ZipArchiveEntry zae = this.entries.nextElement();
                this.stream = this.zipFile.getInputStream(zae);
                return zae;
            }

            public String toString() {
                return file.toString();
            }
        };
    }

    public String toString() {
        return this.getName();
    }
}

