/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.sevenz;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.AbstractArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.sevenz.SevenZArchiveInputStream;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.sevenz.SevenZArchiveOutputStream;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.compressors.FileNameUtil;
import org.apache.commons.compress.utils.Charsets;

public final class SevenZArchiveFormat
extends AbstractArchiveFormat {
    public static final String SYSTEM_PROPERTY_SEVEN_Z_INPUT_FILE_PASSWORD = "sevenZInputFilePassword";
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(Collections.singletonMap(".7z", ""), ".7z");
    private static final ArchiveFormat INSTANCE = new SevenZArchiveFormat();

    private SevenZArchiveFormat() {
    }

    public static ArchiveFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "7z";
    }

    @Override
    public boolean isArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public ArchiveInputStream open(File archiveFile) throws IOException {
        String password = System.getProperty(SYSTEM_PROPERTY_SEVEN_Z_INPUT_FILE_PASSWORD);
        byte[] passwordBytes = password == null ? null : password.getBytes(Charsets.UTF_16LE);
        return new SevenZArchiveInputStream(archiveFile, passwordBytes);
    }

    @Override
    public ArchiveOutputStream create(File archiveFile) throws IOException {
        return new SevenZArchiveOutputStream(new SevenZOutputFile(archiveFile));
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, String name, @Nullable Date lastModifiedDate, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (!(archiveOutputStream instanceof SevenZArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        SevenZArchiveEntry szae = new SevenZArchiveEntry();
        if (lastModifiedDate != null) {
            szae.setLastModifiedDate(lastModifiedDate);
            szae.setCreationDate(lastModifiedDate);
        }
        szae.setName(name);
        archiveOutputStream.putArchiveEntry((ArchiveEntry)szae);
        writeContents.consume((Object)archiveOutputStream);
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public void writeDirectoryEntry(ArchiveOutputStream archiveOutputStream, String name) throws IOException {
        if (!(archiveOutputStream instanceof SevenZArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        SevenZArchiveEntry szae = new SevenZArchiveEntry();
        szae.setDirectory(true);
        szae.setName(name);
        archiveOutputStream.putArchiveEntry((ArchiveEntry)szae);
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, ArchiveEntry archiveEntry, @Nullable String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        SevenZArchiveEntry szae;
        if (!(archiveOutputStream instanceof SevenZArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        if (archiveEntry instanceof SevenZArchiveEntry) {
            szae = (SevenZArchiveEntry)archiveEntry;
            if (name != null) {
                szae.setName(name);
            }
        } else {
            szae = new SevenZArchiveEntry();
            szae.setName(name != null ? name : archiveEntry.getName());
            try {
                szae.setLastModifiedDate(archiveEntry.getLastModifiedDate());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        archiveOutputStream.putArchiveEntry((ArchiveEntry)szae);
        if (!archiveEntry.isDirectory()) {
            writeContents.consume((Object)archiveOutputStream);
        }
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return SevenZFile.matches((byte[])signature, (int)signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

