/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.fileprocessing;

import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.io.EventCounter;
import de.unkrig.commons.io.ExponentiallyLoggingEventCounter;
import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileContentsProcessor<T>
implements FileProcessor<T> {
    private static final Logger LOGGER_INPUT_STREAM_STATISTICS = Logger.getLogger(FileContentsProcessor.class.getName() + ".inputStreamStatistics");
    protected final ContentsProcessor<T> contentsProcessor;
    private static final EventCounter FILE_INPUT_STREAM_STATISTICS = new ExponentiallyLoggingEventCounter("fileInputStream", LOGGER_INPUT_STREAM_STATISTICS, Level.FINE);

    public FileContentsProcessor(ContentsProcessor<T> contentsProcessor) {
        this.contentsProcessor = contentsProcessor;
    }

    @Override
    @Nullable
    public T process(String path, final File file) throws FileNotFoundException, IOException {
        T t;
        long lastModified = file.lastModified();
        Date lastModifiedDate = lastModified == 0L ? null : new Date(lastModified);
        InputStream is = FileContentsProcessor.fileInputStream(file);
        try {
            this.contentsProcessor.process(file.getPath(), is, lastModifiedDate, file.length(), -1L, new ProducerWhichThrows<InputStream, IOException>(){

                @Nullable
                public InputStream produce() throws IOException {
                    return FileContentsProcessor.fileInputStream(file);
                }
            });
            is.close();
            t = null;
        }
        catch (IOException ioe) {
            throw (IOException)ExceptionUtil.wrap((String)file.getPath(), (Throwable)ioe);
        }
        catch (RuntimeException re) {
            throw (RuntimeException)ExceptionUtil.wrap((String)file.getPath(), (Throwable)re);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return t;
    }

    private static InputStream fileInputStream(File file) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(file);
        return InputStreams.statisticsInputStream((InputStream)is, (EventCounter)FILE_INPUT_STREAM_STATISTICS);
    }
}

