/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.contentstransformation;

import de.unkrig.commons.file.CompressUtil;
import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.contentstransformation.ContentsTransformer;
import de.unkrig.commons.file.contentstransformation.ContentsTransformerByteFilter;
import de.unkrig.commons.file.filetransformation.FileTransformations;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.io.ByteFilter;
import de.unkrig.commons.io.ByteFilterInputStream;
import de.unkrig.commons.io.ByteFilterOutputStream;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.HardReference;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.Glob;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;

public final class ContentsTransformations {
    public static final ContentsTransformer COPY;

    private ContentsTransformations() {
    }

    public static ContentsTransformer compressedAndArchiveContentsTransformer(final Predicate<? super String> lookIntoFormat, final Predicate<? super String> archiveEntryRemoval, final Glob archiveEntryRenaming, final ContentsTransformer archiveEntryContentsTransformer, final FileTransformations.ArchiveCombiner archiveCombiner, final ContentsTransformer compressedContentsTransformer, final ContentsTransformer normalContentsTransformer, final ExceptionHandler<IOException> exceptionHandler) {
        return new ContentsTransformer(){

            @Override
            public void transform(final String path, InputStream is, OutputStream os) throws IOException {
                CompressUtil.processStream(is, null, (Predicate<? super ArchiveFormat>)new Predicate<ArchiveFormat>(){

                    public boolean evaluate(ArchiveFormat af) {
                        return lookIntoFormat.evaluate((Object)(af.getName() + ':' + path));
                    }

                    public String toString() {
                        return "path =* " + lookIntoFormat;
                    }
                }, ContentsTransformations.archiveHandler(path, os, (Predicate<? super String>)archiveEntryRemoval, archiveEntryRenaming, archiveEntryContentsTransformer, archiveCombiner, exceptionHandler), (Predicate<? super CompressionFormat>)new Predicate<CompressionFormat>(){

                    public boolean evaluate(CompressionFormat cf) {
                        return lookIntoFormat.evaluate((Object)(cf.getName() + ':' + path));
                    }

                    public String toString() {
                        return "compression-format + ':' + path =* " + lookIntoFormat;
                    }
                }, ContentsTransformations.compressorHandler(path, os, compressedContentsTransformer), ContentsTransformations.normalContentsHandler(path, os, normalContentsTransformer));
            }

            public String toString() {
                return "compressedAndArchiveContentsTransformer";
            }
        };
    }

    public static ContentsTransformer recursiveCompressedAndArchiveContentsTransformer(Predicate<? super String> lookIntoFormat, Predicate<? super String> archiveEntryRemoval, Glob archiveEntryRenaming, FileTransformations.ArchiveCombiner archiveCombiner, ContentsTransformer delegate, ExceptionHandler<IOException> exceptionHandler) {
        final HardReference loopback = new HardReference();
        ContentsTransformer tmp = new ContentsTransformer(){

            @Override
            public void transform(String name, InputStream is, OutputStream os) throws IOException {
                ContentsTransformer l = (ContentsTransformer)loopback.get();
                assert (l != null);
                l.transform(name, is, os);
            }
        };
        ContentsTransformer result = ContentsTransformations.compressedAndArchiveContentsTransformer(lookIntoFormat, archiveEntryRemoval, archiveEntryRenaming, tmp, archiveCombiner, tmp, delegate, exceptionHandler);
        loopback.set((Object)result);
        return result;
    }

    public static void transformArchive(String path, final ArchiveInputStream archiveInputStream, final ArchiveOutputStream archiveOutputStream, Predicate<? super String> archiveEntryRemoval, Glob archiveEntryRenaming, final ContentsTransformer contentsTransformer, FileTransformations.ArchiveCombiner archiveCombiner, ExceptionHandler<IOException> exceptionHandler) throws IOException {
        final ArchiveFormat outputFormat = ArchiveFormatFactory.forArchiveOutputStream(archiveOutputStream);
        ArchiveEntry ae = archiveInputStream.getNextEntry();
        while (ae != null) {
            final String entryPath = path + '!' + ArchiveFormatFactory.normalizeEntryName(ae.getName());
            if (!archiveEntryRemoval.evaluate((Object)entryPath)) {
                int idx;
                String newName = archiveEntryRenaming.replace(entryPath);
                if (newName != null && (idx = newName.lastIndexOf(33)) != -1) {
                    if (!path.equals(newName.substring(0, idx))) {
                        throw new IOException("Cannot rename '" + entryPath + "' across archive boundaries");
                    }
                    newName = newName.substring(idx + 1);
                    assert (newName != null);
                }
                try {
                    outputFormat.writeEntry(archiveOutputStream, ae, newName, (ConsumerWhichThrows<? super OutputStream, ? extends IOException>)new ConsumerWhichThrows<OutputStream, IOException>(){

                        public void consume(OutputStream os) throws IOException {
                            contentsTransformer.transform(entryPath, (InputStream)archiveInputStream, os);
                        }

                        public String toString() {
                            return "WRITE CONTENTS OF ARCHIVE ENTRY '" + entryPath + "'";
                        }
                    });
                }
                catch (IOException ioe) {
                    exceptionHandler.handle(path, (IOException)((Exception)ExceptionUtil.wrap((String)("Transforming entry '" + ae + "'"), (Throwable)ioe)));
                }
                catch (RuntimeException re) {
                    exceptionHandler.handle(path, (RuntimeException)ExceptionUtil.wrap((String)("Transforming entry '" + ae + "'"), (Throwable)re));
                }
            }
            ae = archiveInputStream.getNextEntry();
        }
        archiveCombiner.combineArchive(path, (ConsumerWhichThrows<? super FileTransformations.NameAndContents, ? extends IOException>)new ConsumerWhichThrows<FileTransformations.NameAndContents, IOException>(){

            public void consume(final FileTransformations.NameAndContents nac) throws IOException {
                outputFormat.writeEntry(archiveOutputStream, nac.getName(), nac.getLastModifiedDate(), (ConsumerWhichThrows<? super OutputStream, ? extends IOException>)new ConsumerWhichThrows<OutputStream, IOException>(){

                    public void consume(OutputStream os) throws IOException {
                        IoUtil.copy((InputStream)nac.open(), (boolean)true, (OutputStream)os, (boolean)false);
                    }
                });
            }

            public String toString() {
                return "ADD TO ARCHIVE";
            }
        });
    }

    public static CompressUtil.ArchiveHandler<Void> archiveHandler(final String path, final OutputStream os, final Predicate<? super String> archiveEntryRemoval, final Glob archiveEntryRenaming, final ContentsTransformer contentsTransformer, final FileTransformations.ArchiveCombiner archiveFileCombiner, final ExceptionHandler<IOException> exceptionHandler) {
        return new CompressUtil.ArchiveHandler<Void>(){

            @Override
            @Nullable
            public Void handleArchive(ArchiveInputStream archiveInputStream, ArchiveFormat archiveFormat) throws IOException {
                ArchiveOutputStream aos;
                try {
                    aos = archiveFormat.archiveOutputStream(os);
                }
                catch (ArchiveException ae) {
                    throw new IOException(path, ae);
                }
                ContentsTransformations.transformArchive(path, archiveInputStream, aos, (Predicate<? super String>)archiveEntryRemoval, archiveEntryRenaming, contentsTransformer, archiveFileCombiner, exceptionHandler);
                aos.finish();
                return null;
            }
        };
    }

    public static CompressUtil.CompressorHandler<Void> compressorHandler(final String path, final OutputStream os, final ContentsTransformer contentsTransformer) {
        return new CompressUtil.CompressorHandler<Void>(){

            @Override
            @Nullable
            public Void handleCompressor(CompressorInputStream compressorInputStream, CompressionFormat compressionFormat) throws IOException {
                CompressorOutputStream cos;
                try {
                    cos = compressionFormat.compressorOutputStream(os);
                }
                catch (CompressorException ce) {
                    throw new IOException(ce);
                }
                contentsTransformer.transform(path + '%', (InputStream)compressorInputStream, (OutputStream)cos);
                cos.flush();
                return null;
            }
        };
    }

    public static CompressUtil.NormalContentsHandler<Void> normalContentsHandler(final String path, final OutputStream os, final ContentsTransformer contentsTransformer) {
        return new CompressUtil.NormalContentsHandler<Void>(){

            @Override
            @Nullable
            public Void handleNormalContents(InputStream inputStream, @Nullable Date lastModifiedDate) throws IOException {
                contentsTransformer.transform(path, inputStream, os);
                return null;
            }
        };
    }

    public static ContentsTransformer chain(final ContentsTransformer transformer1, final ContentsTransformer transformer2) {
        if (transformer1 == COPY) {
            return transformer2;
        }
        if (transformer2 == COPY) {
            return transformer1;
        }
        return new ContentsTransformer(){

            @Override
            public void transform(String name, InputStream is, OutputStream os) throws IOException {
                transformer2.transform(name, (InputStream)new ByteFilterInputStream(is, (ByteFilter)new ContentsTransformerByteFilter(transformer1, name)), os);
            }
        };
    }

    public static InputStream asInputStream(InputStream delegate, ContentsTransformer transformer, String name) {
        if (transformer == COPY) {
            return delegate;
        }
        return new ByteFilterInputStream(delegate, (ByteFilter)new ContentsTransformerByteFilter(transformer, name));
    }

    public static OutputStream asOutputStream(ContentsTransformer transformer, OutputStream delegate, String name) {
        if (transformer == COPY) {
            return delegate;
        }
        return new ByteFilterOutputStream((ByteFilter)new ContentsTransformerByteFilter(transformer, name), delegate);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        COPY = new ContentsTransformer(){

            @Override
            public void transform(String name, InputStream is, OutputStream os) throws IOException {
                IoUtil.copy((InputStream)is, (OutputStream)os);
            }

            public String toString() {
                return "COPY";
            }
        };
    }
}

