/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.compressors.z;

import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.util.collections.MapUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.FileNameUtil;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;

public final class ZCompressionFormat
implements CompressionFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(MapUtil.map((Object[])new Object[]{".Z", "", ".taz", ".tar", ".tz", ".tar"}), ".Z");
    private static final CompressionFormat INSTANCE = new ZCompressionFormat();

    private ZCompressionFormat() {
    }

    public static CompressionFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "z";
    }

    @Override
    public boolean isCompressedFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getCompressedFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public String getUncompressedFileName(String fileName) {
        return FILE_NAME_UTIL.getUncompressedFilename(fileName);
    }

    @Override
    public CompressorInputStream compressorInputStream(InputStream is) throws IOException {
        return new ZCompressorInputStream(is);
    }

    @Override
    public CompressorInputStream open(File compressedFile) throws IOException {
        FileInputStream is = new FileInputStream(compressedFile);
        try {
            return new ZCompressorInputStream((InputStream)is);
        }
        catch (IOException ioe) {
            try {
                ((InputStream)is).close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw ioe;
        }
    }

    @Override
    public CompressorOutputStream compressorOutputStream(OutputStream os) throws CompressorException {
        throw new CompressorException("Creation of 'Z' compressed contents is not supported");
    }

    @Override
    public CompressorOutputStream create(File compressedFile) throws CompressorException {
        throw new CompressorException("Creation of 'Z' compressed files is not supported");
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return ZCompressorInputStream.matches((byte[])signature, (int)signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

