/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.compressors.pack200;

import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorOutputStream;

public final class Pack200CompressionFormat
implements CompressionFormat {
    private static final CompressionFormat INSTANCE = new Pack200CompressionFormat();

    private Pack200CompressionFormat() {
    }

    public static CompressionFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "pack200";
    }

    @Override
    public boolean isCompressedFileName(String fileName) {
        return false;
    }

    @Override
    public String getCompressedFileName(String fileName) {
        return fileName;
    }

    @Override
    public String getUncompressedFileName(String fileName) {
        return fileName;
    }

    @Override
    public CompressorInputStream compressorInputStream(InputStream is) throws IOException {
        return new Pack200CompressorInputStream(is);
    }

    @Override
    public CompressorInputStream open(File compressedFile) throws IOException {
        FileInputStream is = new FileInputStream(compressedFile);
        try {
            return new Pack200CompressorInputStream((InputStream)is);
        }
        catch (IOException ioe) {
            try {
                ((InputStream)is).close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw ioe;
        }
    }

    @Override
    public CompressorOutputStream compressorOutputStream(OutputStream os) throws IOException {
        return new Pack200CompressorOutputStream(os);
    }

    @Override
    public CompressorOutputStream create(File compressedFile) throws IOException {
        FileOutputStream os = new FileOutputStream(compressedFile);
        try {
            return new Pack200CompressorOutputStream((OutputStream)os);
        }
        catch (IOException ioe) {
            try {
                ((OutputStream)os).close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw ioe;
        }
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return Pack200CompressorInputStream.matches((byte[])signature, (int)signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

