/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers;

import de.unkrig.commons.nullanalysis.Nullable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;

public abstract class ArchiveURLStreamHandler
extends URLStreamHandler {
    protected abstract ArchiveInputStream open(InputStream var1) throws ArchiveException;

    @Override
    protected URLConnection openConnection(@Nullable URL url) {
        assert (url != null);
        return new URLConnection(url){
            @Nullable
            private URL container;
            @Nullable
            private String entryName;

            @Override
            public void connect() throws IOException {
                if (this.connected) {
                    return;
                }
                String authority = this.url.getAuthority();
                String host = this.url.getHost();
                String path = this.url.getPath();
                int port = this.url.getPort();
                String query = this.url.getQuery();
                String ref = this.url.getRef();
                String userInfo = this.url.getUserInfo();
                if (authority != null) {
                    throw new IllegalArgumentException(this.url + ": 'Authority' not allowed");
                }
                if (host.length() > 0) {
                    throw new IllegalArgumentException(this.url + ": 'Host' not allowed");
                }
                if (port != -1) {
                    throw new IllegalArgumentException(this.url + ": 'Port' not allowed");
                }
                if (query != null) {
                    throw new IllegalArgumentException(this.url + ": 'Query' not allowed");
                }
                if (ref != null) {
                    throw new IllegalArgumentException(this.url + ": 'Fragment' not allowed");
                }
                if (userInfo != null) {
                    throw new IllegalArgumentException(this.url + ": 'User info' not allowed");
                }
                int excl = path.lastIndexOf(33);
                if (excl == -1) {
                    throw new IllegalArgumentException(this.url + ": '!' missing in path");
                }
                this.container = new URL(path.substring(0, excl));
                this.entryName = path.substring(excl + 1);
                this.connected = true;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                ArchiveInputStream ais;
                this.connect();
                URL container = this.container;
                String entryName = this.entryName;
                assert (container != null);
                assert (entryName != null);
                String relativeEntryName = ArchiveURLStreamHandler.stripLeadingSlashes(entryName);
                try {
                    ais = ArchiveURLStreamHandler.this.open(container.openStream());
                }
                catch (ArchiveException ae) {
                    throw new IOException(ae);
                }
                do {
                    if ((ae = ais.getNextEntry()) != null) continue;
                    try {
                        ais.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new FileNotFoundException(container.toString() + '!' + entryName);
                } while (!ArchiveURLStreamHandler.stripLeadingSlashes(ae.getName()).equals(relativeEntryName));
                return ais;
            }
        };
    }

    private static String stripLeadingSlashes(String s) {
        if (s.isEmpty() || s.charAt(0) != '/') {
            return s;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '/') continue;
            return s.substring(i);
        }
        return "";
    }
}

