/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.filetransformation;

import de.unkrig.commons.file.FileUtil;
import de.unkrig.commons.file.contentstransformation.ContentsTransformer;
import de.unkrig.commons.file.filetransformation.FileTransformations;
import de.unkrig.commons.file.filetransformation.FileTransformer;
import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.MarkableFileInputStream;
import de.unkrig.commons.io.OutputStreams;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.RunnableUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileContentsTransformer
implements FileTransformer {
    private final ContentsTransformer contentsTransformer;
    private final boolean keepOriginals;

    public FileContentsTransformer(ContentsTransformer contentsTransformer, boolean keepOriginals) {
        this.contentsTransformer = contentsTransformer;
        this.keepOriginals = keepOriginals;
    }

    @Override
    public void transform(String path, File in, File out, FileTransformer.Mode mode) throws IOException {
        switch (mode) {
            case CHECK: {
                FileContentsTransformer.checkIdentity(path, (InputStream)new MarkableFileInputStream(in), this.contentsTransformer, true);
                return;
            }
            case CHECK_AND_TRANSFORM: {
                try {
                    this.transform(path, in, out, FileTransformer.Mode.CHECK);
                    if (in.equals(out)) {
                        if (this.keepOriginals) {
                            // empty if block
                        }
                    } else {
                        IoUtil.copy((File)in, (File)out);
                    }
                }
                catch (RuntimeException re) {
                    if (re != FileTransformer.NOT_IDENTICAL) {
                        throw re;
                    }
                    this.transform(path, in, out, FileTransformer.Mode.TRANSFORM);
                }
                return;
            }
            case TRANSFORM: {
                if (in.equals(out)) {
                    this.transformInPlace(in);
                } else {
                    this.transformOutOfPlace(in, out);
                }
                if (!out.setLastModified(in.lastModified())) {
                    throw new IOException("Could not set modification time of '" + out + "'");
                }
                return;
            }
        }
        throw (Error)AssertionUtil.fail((String)("Unexpected mode '" + (Object)((Object)mode) + "'"));
    }

    private void transformInPlace(File file) throws IOException {
        File newFile = FileTransformations.newFile(file);
        this.transformOutOfPlace(file, newFile);
        try {
            if (this.keepOriginals) {
                File origFile = FileTransformations.origFile(file);
                if (origFile.exists()) {
                    FileUtil.deleteRecursively(origFile);
                }
                FileUtil.rename(file, origFile);
            } else {
                FileUtil.deleteRecursively(file);
            }
        }
        catch (IOException ioe) {
            FileUtil.attemptToDeleteRecursively(newFile);
            throw ioe;
        }
        catch (RuntimeException re) {
            FileUtil.attemptToDeleteRecursively(newFile);
            throw re;
        }
        FileUtil.rename(newFile, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformOutOfPlace(File inputFile, File outputFile) throws IOException {
        MarkableFileInputStream is = new MarkableFileInputStream(inputFile);
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            try {
                this.contentsTransformer.transform(inputFile.getPath(), (InputStream)is, os);
                ((OutputStream)os).close();
            }
            catch (IOException ioe) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                outputFile.delete();
                throw (IOException)ExceptionUtil.wrap((String)("Transforming file '" + inputFile + "' into '" + outputFile + "'"), (Throwable)ioe);
            }
            catch (RuntimeException re) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                outputFile.delete();
                throw (RuntimeException)ExceptionUtil.wrap((String)("Transforming file '" + inputFile + "' into '" + outputFile + "'"), (Throwable)re);
            }
            is.close();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIdentity(String path, InputStream inputStream, ContentsTransformer contentsTransformer, boolean closeInputStream) throws IOException {
        try {
            OutputStream[] oss = OutputStreams.compareOutput((int)2, (Runnable)RunnableUtil.NOP, (Runnable)FileTransformer.THROW_NOT_IDENTICAL);
            contentsTransformer.transform(path, InputStreams.wye((InputStream)inputStream, (OutputStream)oss[0]), oss[1]);
            oss[0].close();
            oss[1].close();
            if (closeInputStream) {
                inputStream.close();
            }
        }
        finally {
            if (closeInputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

