/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.doclet.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import de.unkrig.commons.doclet.Docs;
import de.unkrig.commons.doclet.Tags;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.commons.nullanalysis.Nullable;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;

public class Html {
    public static final LinkMaker STANDARD_LINK_MAKER;
    private static final String LINE_SEPARATOR;
    private final LinkMaker linkMaker;
    private static final Pattern AMPERSAND;
    private static final Pattern LESS_THAN;
    private static final Pattern GREATER_THAN;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        STANDARD_LINK_MAKER = new LinkMaker(){

            @Override
            public Link makeLink(Doc from, Doc to, RootDoc rootDoc) {
                String defaultLabelHtml;
                String href;
                if (to == from && !(to instanceof ClassDoc)) {
                    href = null;
                } else if (!to.isIncluded() && !(to instanceof RootDoc)) {
                    href = null;
                } else {
                    PackageDoc toPackage;
                    StringBuilder sb = new StringBuilder();
                    PackageDoc fromPackage = Docs.packageScope(from);
                    if (fromPackage != null) {
                        String[] stringArray = fromPackage.name().split("\\.");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String component = stringArray[n2];
                            sb.append("../");
                            ++n2;
                        }
                    }
                    if ((toPackage = Docs.packageScope(to)) != null) {
                        sb.append(toPackage.name().replace('.', '/')).append('/');
                        ClassDoc toClass = Docs.classScope(to);
                        if (toClass == null) {
                            sb.append("index.html");
                        } else {
                            sb.append(toClass.name()).append(".html");
                        }
                        sb.append(Html.fragmentIdentifier(to));
                    }
                    href = sb.toString();
                }
                if (!(to instanceof MemberDoc)) {
                    defaultLabelHtml = to.name();
                } else {
                    MemberDoc toMember = (MemberDoc)to;
                    String string = defaultLabelHtml = toMember.containingClass() == from || from instanceof MemberDoc && toMember.containingClass() == ((MemberDoc)from).containingClass() ? "" : String.valueOf(toMember.containingClass().name()) + '.';
                    if (to.isField()) {
                        defaultLabelHtml = String.valueOf(defaultLabelHtml) + to.name();
                    } else if (to.isConstructor()) {
                        ConstructorDoc toConstructorDoc = (ConstructorDoc)to;
                        defaultLabelHtml = String.valueOf(defaultLabelHtml) + toConstructorDoc.containingClass().name() + this.prettyPrintParameterList((ExecutableMemberDoc)toConstructorDoc);
                    } else if (to.isMethod()) {
                        MethodDoc toMethodDoc = (MethodDoc)to;
                        defaultLabelHtml = String.valueOf(defaultLabelHtml) + to.name() + this.prettyPrintParameterList((ExecutableMemberDoc)toMethodDoc);
                    } else {
                        throw new IllegalArgumentException(String.valueOf(to));
                    }
                }
                return new Link(href, defaultLabelHtml);
            }

            private String prettyPrintParameterList(ExecutableMemberDoc executableMemberDoc) {
                StringBuilder result = new StringBuilder().append('(');
                int i = 0;
                while (i < executableMemberDoc.parameters().length) {
                    Type pt;
                    Parameter parameter = executableMemberDoc.parameters()[i];
                    if (i > 0) {
                        result.append(", ");
                    }
                    if ((pt = parameter.type()).isPrimitive()) {
                        result.append(pt.toString());
                    } else {
                        ClassDoc cd = pt.asClassDoc();
                        if (!$assertionsDisabled && cd == null) {
                            throw new AssertionError(parameter);
                        }
                        result.append(cd.name());
                    }
                    ++i;
                }
                result.append(')');
                return result.toString();
            }
        };
        LINE_SEPARATOR = System.getProperty("line.separator");
        AMPERSAND = Pattern.compile("&");
        LESS_THAN = Pattern.compile("<");
        GREATER_THAN = Pattern.compile(">");
    }

    private static String fragmentIdentifier(Doc doc) {
        if (doc.isField()) {
            return String.valueOf('#') + doc.name();
        }
        if (doc.isConstructor()) {
            ConstructorDoc constructorDoc = (ConstructorDoc)doc;
            return String.valueOf('#') + constructorDoc.containingClass().name() + Html.parameterListForFragmentIdentifier((ExecutableMemberDoc)constructorDoc);
        }
        if (doc.isMethod()) {
            MethodDoc methodDoc = (MethodDoc)doc;
            return String.valueOf('#') + doc.name() + Html.parameterListForFragmentIdentifier((ExecutableMemberDoc)methodDoc);
        }
        return "";
    }

    private static String parameterListForFragmentIdentifier(ExecutableMemberDoc executableMemberDoc) {
        StringBuilder result = new StringBuilder().append('(');
        int i = 0;
        while (i < executableMemberDoc.parameters().length) {
            Parameter parameter = executableMemberDoc.parameters()[i];
            if (i > 0) {
                result.append(", ");
            }
            result.append(parameter.type().qualifiedTypeName());
            ++i;
        }
        return result.append(')').toString();
    }

    public Html(LinkMaker linkMaker) {
        this.linkMaker = linkMaker;
    }

    public String fromTags(Tag[] tags, Doc ref, RootDoc rootDoc) throws Longjump {
        StringBuilder sb = new StringBuilder();
        Tag[] tagArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            Tag tag = tagArray[n2];
            sb.append(this.expandTag(ref, rootDoc, tag));
            ++n2;
        }
        return sb.toString();
    }

    protected String expandTag(Doc ref, RootDoc rootDoc, Tag tag) throws Longjump {
        String tagName = tag.name();
        String argument = tag.text();
        if ("Text".equals(tagName)) {
            if (argument == null) {
                return "";
            }
            int idx = argument.indexOf(10);
            while (idx != -1) {
                if (idx == argument.length() - 1) {
                    argument = String.valueOf(argument.substring(0, idx)) + LINE_SEPARATOR;
                    break;
                }
                char c = argument.charAt(idx + 1);
                if (c == '\n') {
                    argument = String.valueOf(argument.substring(0, idx)) + LINE_SEPARATOR + argument.substring(idx + 1);
                    idx += LINE_SEPARATOR.length();
                } else if (c == ' ') {
                    argument = String.valueOf(argument.substring(0, idx)) + LINE_SEPARATOR + argument.substring(idx + 2);
                    idx += LINE_SEPARATOR.length();
                } else {
                    argument = String.valueOf(argument.substring(0, idx)) + argument.substring(idx + 1);
                }
                idx = argument.indexOf(10, idx);
            }
            return argument;
        }
        if ("@code".equals(tagName)) {
            if (argument == null) {
                rootDoc.printError(ref.position(), "Argument missing for  '{@code ...}' tag");
                return "";
            }
            argument = Html.escapeSgmlEntities(argument);
            return "<code>" + argument + "</code>";
        }
        if ("@literal".equals(tagName)) {
            if (argument == null) {
                rootDoc.printError(ref.position(), "Argument missing for  '{@literal ...}' tag");
                return "";
            }
            return Html.escapeSgmlEntities(argument);
        }
        if ("@value".equals(tagName)) {
            Doc doc;
            if (argument == null) {
                rootDoc.printError(ref.position(), "Argument missing for  '{@value ...}' tag");
                return "";
            }
            Doc doc2 = doc = argument.length() == 0 ? ref : Docs.findDoc(ref, argument, rootDoc);
            if (doc == null) {
                rootDoc.printError(ref.position(), "Field '" + argument + "' not found");
                return argument;
            }
            if (!(doc instanceof FieldDoc)) {
                rootDoc.printError(doc.position(), "'" + argument + "' does not designate a field");
                return argument;
            }
            Object cv = ((FieldDoc)doc).constantValue();
            if (cv == null) {
                rootDoc.printError(doc.position(), "Field '" + argument + "' does not have a constant value");
                return argument;
            }
            return this.makeLink(ref, doc, true, cv.toString(), null, rootDoc);
        }
        if ("@link".equals(tagName) || "@linkplain".equals(tagName)) {
            if (argument == null) {
                rootDoc.printError(ref.position(), "Argument missing for '{@link ...}' tag");
                return "";
            }
            Doc target = Html.targetOfSeeTag((SeeTag)tag);
            if (target == null) {
                rootDoc.printError(ref.position(), "Target \"" + tag.text() + "\" of {@link} tag not found");
                return "???";
            }
            return this.makeLink(ref, target, "@linkplain".equals(tagName), ((SeeTag)tag).label(), null, rootDoc);
        }
        if ("@docRoot".equals(tagName)) {
            String href = this.linkMaker.makeLink((Doc)ref, (Doc)rootDoc, (RootDoc)rootDoc).href;
            return href == null ? "" : href;
        }
        if ("@constantsof".equals(tagName) || "@constantsofplain".equals(tagName)) {
            Doc doc;
            if (argument == null) {
                rootDoc.printError(ref.position(), "Argument missing for  '{@constantsof ...}' tag");
                return "";
            }
            Doc doc3 = doc = argument.length() == 0 ? ref : Docs.findDoc(ref, argument, rootDoc);
            if (doc == null) {
                rootDoc.printError(ref.position(), "Enum '" + argument + "' not found");
                return argument;
            }
            if (!(doc instanceof ClassDoc)) {
                rootDoc.printError(doc.position(), "'" + argument + "' does not designate an enum type");
                return argument;
            }
            ClassDoc cd = (ClassDoc)doc;
            if (!cd.isEnum()) {
                rootDoc.printError(doc.position(), "Type '" + argument + "' is not an enum");
                return argument;
            }
            FieldDoc[] ecs = cd.enumConstants();
            if (ecs.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (true) {
                FieldDoc ec = ecs[i];
                sb.append(this.makeLink(ref, (Doc)ec, "@constantsofplain".equals(tagName), ec.name(), null, rootDoc));
                if (++i == ecs.length) break;
                sb.append(", ");
            }
            return sb.toString();
        }
        rootDoc.printError(ref.position(), "Inline tag '{" + tagName + "}' is not supported; you could " + "(A) remove it from the text, or " + "(B) improve 'Html.expandTag()' to transform it into nice HTML (if that is " + "reasonably possible)");
        return "{" + tagName + (argument == null ? "" : " " + argument) + "}";
    }

    @Nullable
    public static Doc targetOfSeeTag(SeeTag seeTag) {
        MemberDoc target = seeTag.referencedMember();
        if (target != null) {
            return target;
        }
        target = seeTag.referencedClass();
        if (target != null) {
            return target;
        }
        target = seeTag.referencedPackage();
        if (target != null) {
            return target;
        }
        return null;
    }

    public static Doc hrefToDoc(String href, RootDoc rootDoc, ClassDoc from) throws Longjump {
        String prefix = href.startsWith("#") ? from.qualifiedName() : String.valueOf(from.containingPackage().name()) + '.';
        while (href.startsWith("../")) {
            prefix = prefix.substring(0, prefix.lastIndexOf(46, prefix.length() - 2) + 1);
            href = href.substring(3);
        }
        Doc result = Docs.findDoc((Doc)rootDoc, String.valueOf(prefix) + href.replace('/', '.'), rootDoc);
        if (result == null) {
            throw new Longjump();
        }
        return result;
    }

    public String makeLink(Doc from, Doc to, boolean plain, @Nullable String label, @Nullable String target, RootDoc rootDoc) throws Longjump {
        Link link = this.linkMaker.makeLink(from, to, rootDoc);
        if (label == null || label.isEmpty()) {
            label = link.defaultLabelHtml;
        }
        if (!plain) {
            label = "<code>" + label + "</code>";
        }
        if (link.href == null) {
            return label;
        }
        return "<a href=\"" + link.href + "\"" + (to.isOrdinaryClass() ? " title=\"class in " + ((ClassDoc)to).containingPackage().name() + "\"" : (to.isInterface() ? " title=\"interface in " + ((ClassDoc)to).containingPackage().name() + "\"" : "")) + (target == null ? "" : " target=\"" + target + "\"") + ">" + label + "</a>";
    }

    public static String escapeSgmlEntities(String text) {
        text = AMPERSAND.matcher(text).replaceAll("&amp;");
        text = LESS_THAN.matcher(text).replaceAll("&lt;");
        text = GREATER_THAN.matcher(text).replaceAll("&gt;");
        return text;
    }

    @Nullable
    public String optionalTag(Doc doc, String tagName, RootDoc rootDoc) throws Longjump {
        Tag t = Tags.optionalTag(doc, tagName, (DocErrorReporter)rootDoc);
        if (t == null) {
            return null;
        }
        return this.fromTags(t.inlineTags(), doc, rootDoc);
    }

    public String generateFor(Doc doc, RootDoc rootDoc) throws Longjump {
        String htmlText = "";
        Tag[] tagArray = doc.tags("@deprecated");
        int n = tagArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tag dt = tagArray[n2];
            htmlText = String.valueOf(htmlText) + "<div class=\"block\"><span class=\"strong\">Deprecated.</span>&nbsp;<i>" + this.fromTags(dt.inlineTags(), doc, rootDoc) + "</i></div>";
            ++n2;
        }
        htmlText = String.valueOf(htmlText) + this.fromTags(doc.inlineTags(), doc, rootDoc);
        Tag[] seeTags = doc.tags("@see");
        if (seeTags.length == 0) {
            return htmlText;
        }
        StringBuilder sb = new StringBuilder(htmlText).append("<dl><dt>See also:</dt>");
        Tag[] tagArray2 = seeTags;
        int n3 = seeTags.length;
        int n4 = 0;
        while (n4 < n3) {
            Tag t = tagArray2[n4];
            SeeTag seeTag = (SeeTag)t;
            try {
                sb.append("<dd>");
                Doc target = Html.targetOfSeeTag(seeTag);
                if (target == null) {
                    sb.append(this.fromTags(seeTag.inlineTags(), doc, rootDoc));
                } else {
                    String label = seeTag.label();
                    if (label.length() == 0) {
                        label = null;
                    }
                    sb.append(this.makeLink(doc, target, false, label, null, rootDoc));
                }
                sb.append("</dd>");
            }
            catch (Longjump longjump) {
                // empty catch block
            }
            ++n4;
        }
        sb.append("</dl>");
        return sb.toString();
    }

    public String summaryDescription(Doc doc, RootDoc rootDoc) {
        Tag[] dts = doc.tags("@deprecated");
        try {
            if (dts.length == 0) {
                return this.fromTags(doc.firstSentenceTags(), doc, rootDoc);
            }
            return "<div class=\"block\"><strong>Deprecated.</strong><div class=\"block\"><i>" + this.fromTags(dts[0].inlineTags(), doc, rootDoc) + "</i></div></div>";
        }
        catch (Longjump e) {
            return "???";
        }
    }

    public static final class ExternalJavadocsLinkMaker
    implements LinkMaker {
        private final Map<String, URL> externalJavadocs;
        private final LinkMaker delegate;

        public ExternalJavadocsLinkMaker(Map<String, URL> externalJavadocs, LinkMaker delegate) {
            this.externalJavadocs = externalJavadocs;
            this.delegate = delegate;
        }

        @Override
        public Link makeLink(Doc from, Doc to, RootDoc rootDoc) throws Longjump {
            PackageDoc toPackage = Docs.packageScope(to);
            assert (toPackage != null);
            URL url = this.externalJavadocs.get(toPackage.name());
            if (url == null) {
                return this.delegate.makeLink(from, to, rootDoc);
            }
            ClassDoc toClass = Docs.classScope(to);
            String href = toClass == null ? String.valueOf(url.toString()) + '/' + toPackage.name().replace('.', '/') + "/index.html" : url + toClass.qualifiedName().replace('.', '/') + ".html" + Html.fragmentIdentifier(to);
            String defaultLabelHtml = Html.STANDARD_LINK_MAKER.makeLink((Doc)from, (Doc)to, (RootDoc)rootDoc).defaultLabelHtml;
            return new Link(href, defaultLabelHtml);
        }
    }

    public static final class Link {
        @Nullable
        public final String href;
        public final String defaultLabelHtml;

        public Link(@Nullable String href, String defaultLabelHtml) {
            this.href = href;
            this.defaultLabelHtml = defaultLabelHtml;
        }
    }

    public static interface LinkMaker {
        public Link makeLink(Doc var1, Doc var2, RootDoc var3) throws Longjump;
    }
}

