/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.doclet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.Array;

public final class Annotations {
    private Annotations() {
    }

    @Nullable
    public static AnnotationDesc get(ProgramElementDoc doc, String annotationTypeSimpleName) {
        for (AnnotationDesc ad : doc.annotations()) {
            if (!ad.annotationType().simpleTypeName().equals(annotationTypeSimpleName)) continue;
            return ad;
        }
        return null;
    }

    @Nullable
    public static AnnotationDesc get(ProgramElementDoc doc, ClassDoc annotationType) {
        for (AnnotationDesc ad : doc.annotations()) {
            if (!ad.annotationType().equals(annotationType)) continue;
            return ad;
        }
        return null;
    }

    @Nullable
    public static AnnotationDesc get(ProgramElementDoc doc, Class<?> annotationType, RootDoc rootDoc) throws Longjump {
        ClassDoc brpcd = rootDoc.classNamed(annotationType.getName());
        return Annotations.get(doc, brpcd);
    }

    @Nullable
    public static <T> T getElementValue(AnnotationDesc annotationDesc, String elementName, Class<T> clasS) {
        Object[] oa;
        Object result = Annotations.getAnnotationElementValue(annotationDesc, elementName);
        if (result == null) {
            return null;
        }
        if (clasS.isArray() && result instanceof Object[]) {
            oa = (Object[])result;
            result = Array.newInstance(clasS.getComponentType(), oa.length);
            System.arraycopy(oa, 0, result, 0, oa.length);
        } else if (clasS == String.class && result instanceof Object[]) {
            oa = (Object[])result;
            if (oa.length == 0) {
                result = "";
            } else if (oa.length == 1) {
                result = String.valueOf(oa[0]);
            } else {
                StringBuilder sb = new StringBuilder().append(oa[0]);
                for (int i = 1; i < oa.length; ++i) {
                    sb.append(',').append(oa[i]);
                }
                result = sb.toString();
            }
        }
        assert (clasS.isAssignableFrom(result.getClass()));
        Object tmp = result;
        return (T)tmp;
    }

    @Nullable
    public static Object getAnnotationElementValue(AnnotationDesc annotationDesc, String elementName) {
        for (AnnotationDesc.ElementValuePair evp : annotationDesc.elementValues()) {
            if (!evp.element().name().equals(elementName)) continue;
            return Annotations.getAnnotationValue(evp.value());
        }
        return null;
    }

    @Nullable
    public static Object getAnnotationValue(AnnotationValue value) {
        Object o = value.value();
        if (o instanceof AnnotationValue[]) {
            AnnotationValue[] avs = (AnnotationValue[])o;
            Object[] oa = new Object[avs.length];
            for (int i = 0; i < avs.length; ++i) {
                oa[i] = Annotations.getAnnotationValue(avs[i]);
            }
            return oa;
        }
        return o;
    }
}

