/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.asm;

import de.unkrig.commons.nullanalysis.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.TraceSignatureVisitor;

public final class Signature {
    private Signature() {
    }

    public static String toString(String className, @Nullable String classSignature) {
        if (classSignature == null) {
            return className.replace('/', '.');
        }
        SignatureWriter sw = new SignatureWriter();
        new SignatureReader(classSignature).accept((SignatureVisitor)sw);
        return sw.toString();
    }

    public static String toString(MethodNode methodNode) {
        return Signature.toString(methodNode.name, methodNode.desc, methodNode.signature);
    }

    public static String toString(String methodName, String methodDescriptor, @Nullable String methodSignature) {
        if (methodSignature != null) {
            TraceSignatureVisitor tsv = new TraceSignatureVisitor(0);
            new SignatureReader(methodSignature).accept((SignatureVisitor)tsv);
            return methodName + tsv.getDeclaration();
        }
        StringBuilder sb = new StringBuilder(methodName).append('(');
        Type[] ats = Type.getArgumentTypes((String)methodDescriptor);
        if (ats.length >= 1) {
            int i = 0;
            while (true) {
                sb.append(ats[i++].getClassName());
                if (i == ats.length) break;
                sb.append(", ");
            }
        }
        return sb.append(')').toString();
    }
}

