/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.asm;

import de.unkrig.commons.asm.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class StringConcatenator {
    private static final Map<Type, String> STRING_BUILDER_APPEND_TYPES;
    private static final Map<Type, String> STRING_VALUE_OF_TYPES;
    private final List<Component> components = new ArrayList<Component>();

    public StringConcatenator appendConstant(String value) {
        Component c;
        if (value.length() == 0) {
            return this;
        }
        if (!this.components.isEmpty() && (c = this.components.get(this.components.size() - 1)) instanceof ConstantComponent) {
            ConstantComponent cc = (ConstantComponent)c;
            cc.value = cc.value + value;
            return this;
        }
        this.components.add(new ConstantComponent(value));
        return this;
    }

    public StringConcatenator appendVariable(InsnList insns, Type type) {
        this.components.add(new VariableComponent(insns, type));
        return this;
    }

    public StringConcatenator appendVariablePrettily(InsnList code, Type type) {
        if (type.getSort() == 9) {
            Type et = type.getElementType();
            if (et.getSort() == 9 || et.getSort() == 10) {
                code.add((AbstractInsnNode)new MethodInsnNode(184, "java/util/Arrays", "deepToString", "([Ljava/lang/Object;)Ljava/lang/String;"));
                this.appendVariable(code, Types.STRING_TYPE);
            } else {
                code.add((AbstractInsnNode)new MethodInsnNode(184, "java/util/Arrays", "toString", "([" + et.getDescriptor() + ")Ljava/lang/String;"));
                this.appendVariable(code, Types.STRING_TYPE);
            }
        } else if (type.equals((Object)Types.STRING_TYPE) || type.equals((Object)Types.STRING_BUFFER_TYPE) || type.equals((Object)Types.STRING_BUILDER_TYPE) || type.equals((Object)Types.CHAR_SEQUENCE_TYPE)) {
            this.appendConstant("\"");
            this.appendVariable(code, type);
            this.appendConstant("\"");
        } else if (type.equals((Object)Type.CHAR_TYPE)) {
            this.appendConstant("'");
            this.appendVariable(code, Type.CHAR_TYPE);
            this.appendConstant("'");
        } else {
            this.appendVariable(code, type);
        }
        return this;
    }

    public InsnList finish() {
        InsnList insns = new InsnList();
        switch (this.components.size()) {
            case 0: {
                insns.add((AbstractInsnNode)new LdcInsnNode((Object)""));
                break;
            }
            case 1: {
                this.components.get(0).pushAsString(insns);
                break;
            }
            case 2: {
                this.components.get(0).pushAsString(insns);
                this.components.get(1).pushAsString(insns);
                insns.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/String", "concat", "(Ljava/lang/String;)Ljava/lang/String;"));
                break;
            }
            default: {
                insns.add((AbstractInsnNode)new TypeInsnNode(187, "java/lang/StringBuilder"));
                insns.add((AbstractInsnNode)new InsnNode(89));
                this.components.get(0).pushAsString(insns);
                insns.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V"));
                for (int i = 1; i < this.components.size(); ++i) {
                    Component c = this.components.get(i);
                    Type t = c.push(insns);
                    String md = STRING_BUILDER_APPEND_TYPES.get(t);
                    if (md == null) {
                        md = "(Ljava/lang/Object;)Ljava/lang/StringBuilder;";
                    }
                    insns.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "append", md));
                }
                insns.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;"));
            }
        }
        return insns;
    }

    static {
        HashMap<Type, String> m = new HashMap<Type, String>();
        m.put(Type.BOOLEAN_TYPE, "(Z)Ljava/lang/StringBuilder;");
        m.put(Type.CHAR_TYPE, "(C)Ljava/lang/StringBuilder;");
        m.put(Type.BYTE_TYPE, "(I)Ljava/lang/StringBuilder;");
        m.put(Type.SHORT_TYPE, "(I)Ljava/lang/StringBuilder;");
        m.put(Type.INT_TYPE, "(I)Ljava/lang/StringBuilder;");
        m.put(Type.FLOAT_TYPE, "(F)Ljava/lang/StringBuilder;");
        m.put(Type.LONG_TYPE, "(J)Ljava/lang/StringBuilder;");
        m.put(Type.DOUBLE_TYPE, "(D)Ljava/lang/StringBuilder;");
        m.put(Types.OBJECT_TYPE, "(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        m.put(Types.CHAR_SEQUENCE_TYPE, "(Ljava/lang/CharSequence;)Ljava/lang/StringBuilder;");
        m.put(Types.STRING_TYPE, "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        m.put(Types.STRING_BUFFER_TYPE, "(Ljava/lang/StringBuffer;)Ljava/lang/StringBuilder;");
        STRING_BUILDER_APPEND_TYPES = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put(Type.BOOLEAN_TYPE, "(Z)Ljava/lang/String;");
        m.put(Type.CHAR_TYPE, "(C)Ljava/lang/String;");
        m.put(Type.BYTE_TYPE, "(I)Ljava/lang/String;");
        m.put(Type.SHORT_TYPE, "(I)Ljava/lang/String;");
        m.put(Type.INT_TYPE, "(I)Ljava/lang/String;");
        m.put(Type.FLOAT_TYPE, "(F)Ljava/lang/String;");
        m.put(Type.LONG_TYPE, "(J)Ljava/lang/String;");
        m.put(Type.DOUBLE_TYPE, "(D)Ljava/lang/String;");
        m.put(Types.OBJECT_TYPE, "(Ljava/lang/Object;)Ljava/lang/String;");
        STRING_VALUE_OF_TYPES = Collections.unmodifiableMap(m);
    }

    class VariableComponent
    implements Component {
        private final InsnList insns;
        private final Type type;

        VariableComponent(InsnList insns, Type type) {
            this.insns = insns;
            this.type = type;
        }

        @Override
        public Type push(InsnList result) {
            result.add(this.insns);
            return this.type;
        }

        @Override
        public void pushAsString(InsnList result) {
            result.add(this.insns);
            String md = (String)STRING_VALUE_OF_TYPES.get(this.type);
            if (md == null) {
                md = "(Ljava/lang/Object;)Ljava/lang/String;";
            }
            result.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/String", "valueOf", md));
        }
    }

    class ConstantComponent
    implements Component {
        String value;

        ConstantComponent(String value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        public Type push(InsnList result) {
            result.add((AbstractInsnNode)new LdcInsnNode((Object)this.value));
            return Types.STRING_TYPE;
        }

        @Override
        public void pushAsString(InsnList result) {
            result.add((AbstractInsnNode)new LdcInsnNode((Object)this.value));
        }
    }

    static interface Component {
        public Type push(InsnList var1);

        public void pushAsString(InsnList var1);
    }
}

