/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.asm;

import org.objectweb.asm.Type;

public final class Types {
    public static final Type OBJECT_TYPE = Type.getObjectType((String)"java/lang/Object");
    public static final Type STRING_TYPE = Type.getObjectType((String)"java/lang/String");
    public static final Type CHAR_SEQUENCE_TYPE = Type.getObjectType((String)"java/lang/CharSequence");
    public static final Type STRING_BUFFER_TYPE = Type.getObjectType((String)"java/lang/StringBuffer");
    public static final Type STRING_BUILDER_TYPE = Type.getObjectType((String)"java/lang/StringBuilder");
    public static final Type BYTE_ARRAY_TYPE = Type.getType((String)"[B");
    public static final Type SHORT_ARRAY_TYPE = Type.getType((String)"[S");
    public static final Type INT_ARRAY_TYPE = Type.getType((String)"[I");
    public static final Type LONG_ARRAY_TYPE = Type.getType((String)"[J");
    public static final Type FLOAT_ARRAY_TYPE = Type.getType((String)"[F");
    public static final Type DOUBLE_ARRAY_TYPE = Type.getType((String)"[D");
    public static final Type CHAR_ARRAY_TYPE = Type.getType((String)"[C");
    public static final Type REFERENCE_ARRAY_TYPE = Type.getType((String)"[Ljava/lang/Object;");

    private Types() {
    }

    public static Type fromOpcode(int opcode) {
        switch (opcode) {
            case 46: 
            case 79: {
                return INT_ARRAY_TYPE;
            }
            case 47: 
            case 80: {
                return LONG_ARRAY_TYPE;
            }
            case 48: 
            case 81: {
                return FLOAT_ARRAY_TYPE;
            }
            case 49: 
            case 82: {
                return DOUBLE_ARRAY_TYPE;
            }
            case 50: 
            case 83: {
                return REFERENCE_ARRAY_TYPE;
            }
            case 51: 
            case 84: {
                return BYTE_ARRAY_TYPE;
            }
            case 52: 
            case 85: {
                return CHAR_ARRAY_TYPE;
            }
            case 53: 
            case 86: {
                return SHORT_ARRAY_TYPE;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 21: 
            case 54: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 145: 
            case 146: 
            case 147: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 172: {
                return Type.INT_TYPE;
            }
            case 9: 
            case 10: 
            case 22: 
            case 55: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 136: 
            case 137: 
            case 138: 
            case 148: 
            case 173: {
                return Type.LONG_TYPE;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 56: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 118: 
            case 139: 
            case 140: 
            case 141: 
            case 149: 
            case 150: 
            case 174: {
                return Type.FLOAT_TYPE;
            }
            case 14: 
            case 15: 
            case 24: 
            case 57: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 119: 
            case 142: 
            case 143: 
            case 144: 
            case 151: 
            case 152: 
            case 175: {
                return Type.DOUBLE_TYPE;
            }
            case 25: 
            case 58: 
            case 165: 
            case 166: 
            case 176: {
                return OBJECT_TYPE;
            }
        }
        throw new IllegalArgumentException(Integer.toString(opcode));
    }
}

