/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.asm;

import de.unkrig.commons.asm.Types;
import de.unkrig.commons.nullanalysis.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;

public final class OpcodeUtil {
    private static final String[] OPCODE_NAMES = new String[]{"NOP", "ACONST_NULL", "ICONST_M1", "ICONST_0", "ICONST_1", "ICONST_2", "ICONST_3", "ICONST_4", "ICONST_5", "LCONST_0", "LCONST_1", "FCONST_0", "FCONST_1", "FCONST_2", "DCONST_0", "DCONST_1 = 15", "BIPUSH", "SIPUSH", "LDC", "LDC_W", "LDC2_W", "ILOAD", "LLOAD", "FLOAD", "DLOAD", "ALOAD", "ILOAD_0", "ILOAD_1", "ILOAD_2", "ILOAD_3", "LLOAD_0", "LLOAD_1", "LLOAD_2", "LLOAD_3", "FLOAD_0", "FLOAD_1", "FLOAD_2", "FLOAD_3", "DLOAD_0", "DLOAD_1", "DLOAD_2", "DLOAD_3", "ALOAD_0", "ALOAD_1", "ALOAD_2", "ALOAD_3", "IALOAD", "LALOAD", "FALOAD", "DALOAD", "AALOAD", "BALOAD", "CALOAD", "SALOAD", "ISTORE", "LSTORE", "FSTORE", "DSTORE", "ASTORE", "ISTORE_0", "ISTORE_1", "ISTORE_2", "ISTORE_3", "LSTORE_0", "LSTORE_1", "LSTORE_2", "LSTORE_3", "FSTORE_0", "FSTORE_1", "FSTORE_2", "FSTORE_3", "DSTORE_0", "DSTORE_1", "DSTORE_2", "DSTORE_3", "ASTORE_0", "ASTORE_1", "ASTORE_2", "ASTORE_3", "IASTORE", "LASTORE", "FASTORE", "DASTORE", "AASTORE", "BASTORE", "CASTORE", "SASTORE", "POP", "POP2", "DUP", "DUP_X1", "DUP_X2", "DUP2", "DUP2_X1", "DUP2_X2", "SWAP", "IADD", "LADD", "FADD", "DADD", "ISUB", "LSUB", "FSUB", "DSUB", "IMUL", "LMUL", "FMUL", "DMUL", "IDIV", "LDIV", "FDIV", "DDIV", "IREM", "LREM", "FREM", "DREM", "INEG", "LNEG", "FNEG", "DNEG", "ISHL", "LSHL", "ISHR", "LSHR", "IUSHR", "LUSHR", "IAND", "LAND", "IOR", "LOR", "IXOR", "LXOR", "IINC", "I2L", "I2F", "I2D", "L2I", "L2F", "L2D", "F2I", "F2L", "F2D", "D2I", "D2L", "D2F", "I2B", "I2C", "I2S", "LCMP", "FCMPL", "FCMPG", "DCMPL", "DCMPG", "IFEQ", "IFNE", "IFLT", "IFGE", "IFGT", "IFLE", "IF_ICMPEQ", "IF_ICMPNE", "IF_ICMPLT", "IF_ICMPGE", "IF_ICMPGT", "IF_ICMPLE", "IF_ACMPEQ", "IF_ACMPNE", "GOTO", "JSR", "RET", "TABLESWITCH", "LOOKUPSWITCH", "IRETURN", "LRETURN", "FRETURN", "DRETURN", "ARETURN", "RETURN", "GETSTATIC", "PUTSTATIC", "GETFIELD", "PUTFIELD", "INVOKEVIRTUAL", "INVOKESPECIAL", "INVOKESTATIC", "INVOKEINTERFACE", "INVOKEDYNAMIC", "NEW", "NEWARRAY", "ANEWARRAY", "ARRAYLENGTH", "ATHROW", "CHECKCAST", "INSTANCEOF", "MONITORENTER", "MONITOREXIT", "WIDE", "MULTIANEWARRAY", "IFNULL", "IFNONNULL", "GOTO_W", "JSR_W", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static final InsnDescription[] INSN_DESCRIPTIONS = new InsnDescription[256];

    private OpcodeUtil() {
    }

    public static String getName(AbstractInsnNode ain) {
        return OPCODE_NAMES[ain.getOpcode()];
    }

    private static void initDescriptions() {
        OpcodeUtil.addRInsn(Type.INT_TYPE, 21);
        OpcodeUtil.addRInsn(Type.LONG_TYPE, 22);
        OpcodeUtil.addRInsn(Type.FLOAT_TYPE, 23);
        OpcodeUtil.addRInsn(Type.DOUBLE_TYPE, 24);
        OpcodeUtil.addRInsn(Types.OBJECT_TYPE, 25);
        OpcodeUtil.addAInsn(Type.INT_TYPE, 54);
        OpcodeUtil.addAInsn(Type.LONG_TYPE, 55);
        OpcodeUtil.addAInsn(Type.FLOAT_TYPE, 56);
        OpcodeUtil.addAInsn(Type.DOUBLE_TYPE, 57);
        OpcodeUtil.addAInsn(Types.OBJECT_TYPE, 58);
        OpcodeUtil.addAARInsn(Types.INT_ARRAY_TYPE, Type.INT_TYPE, Type.INT_TYPE, 46);
        OpcodeUtil.addAARInsn(Types.LONG_ARRAY_TYPE, Type.INT_TYPE, Type.LONG_TYPE, 47);
        OpcodeUtil.addAARInsn(Types.FLOAT_ARRAY_TYPE, Type.INT_TYPE, Type.FLOAT_TYPE, 48);
        OpcodeUtil.addAARInsn(Types.DOUBLE_ARRAY_TYPE, Type.INT_TYPE, Type.DOUBLE_TYPE, 49);
        OpcodeUtil.addAARInsn(Types.REFERENCE_ARRAY_TYPE, Type.INT_TYPE, Types.OBJECT_TYPE, 50);
        OpcodeUtil.addAARInsn(Types.BYTE_ARRAY_TYPE, Type.INT_TYPE, Type.BYTE_TYPE, 51);
        OpcodeUtil.addAARInsn(Types.CHAR_ARRAY_TYPE, Type.INT_TYPE, Type.CHAR_TYPE, 52);
        OpcodeUtil.addAARInsn(Types.SHORT_ARRAY_TYPE, Type.INT_TYPE, Type.SHORT_TYPE, 53);
        OpcodeUtil.addAAAInsn(Types.INT_ARRAY_TYPE, Type.INT_TYPE, Type.INT_TYPE, 79);
        OpcodeUtil.addAAAInsn(Types.LONG_ARRAY_TYPE, Type.INT_TYPE, Type.LONG_TYPE, 80);
        OpcodeUtil.addAAAInsn(Types.FLOAT_ARRAY_TYPE, Type.INT_TYPE, Type.LONG_TYPE, 81);
        OpcodeUtil.addAAAInsn(Types.DOUBLE_ARRAY_TYPE, Type.INT_TYPE, Type.DOUBLE_TYPE, 82);
        OpcodeUtil.addAAAInsn(Types.REFERENCE_ARRAY_TYPE, Type.INT_TYPE, Types.OBJECT_TYPE, 83);
        OpcodeUtil.addAAAInsn(Types.BYTE_ARRAY_TYPE, Type.INT_TYPE, Type.BYTE_TYPE, 84);
        OpcodeUtil.addAAAInsn(Types.CHAR_ARRAY_TYPE, Type.INT_TYPE, Type.CHAR_TYPE, 85);
        OpcodeUtil.addAAAInsn(Types.SHORT_ARRAY_TYPE, Type.INT_TYPE, Type.SHORT_TYPE, 86);
        OpcodeUtil.addAARInsn(Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 96, 100, 104, 108, 112, 126, 128, 130);
        OpcodeUtil.addAARInsn(Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 97, 101, 105, 109, 113, 127, 129, 131);
        OpcodeUtil.addAARInsn(Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, 98, 102, 106, 110, 114);
        OpcodeUtil.addAARInsn(Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 99, 103, 107, 111, 115);
        OpcodeUtil.addAARInsn(Type.LONG_TYPE, Type.LONG_TYPE, Type.INT_TYPE, 148);
        OpcodeUtil.addAARInsn(Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.INT_TYPE, 150, 149);
        OpcodeUtil.addAARInsn(Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.INT_TYPE, 152, 151);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.INT_TYPE, 116);
        OpcodeUtil.addARInsn(Type.LONG_TYPE, Type.LONG_TYPE, 117);
        OpcodeUtil.addARInsn(Type.FLOAT_TYPE, Type.FLOAT_TYPE, 118);
        OpcodeUtil.addARInsn(Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 119);
        OpcodeUtil.addAARInsn(Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 120, 122, 124);
        OpcodeUtil.addAARInsn(Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE, 121, 123, 125);
        OpcodeUtil.addAAInsn(Type.INT_TYPE, Type.INT_TYPE, 159, 160, 161, 162, 163, 164);
        OpcodeUtil.addAAInsn(Types.OBJECT_TYPE, Types.OBJECT_TYPE, 165, 166);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.LONG_TYPE, 133);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.FLOAT_TYPE, 134);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.DOUBLE_TYPE, 135);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.BYTE_TYPE, 145);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.CHAR_TYPE, 146);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.SHORT_TYPE, 147);
        OpcodeUtil.addARInsn(Type.LONG_TYPE, Type.INT_TYPE, 136);
        OpcodeUtil.addARInsn(Type.LONG_TYPE, Type.FLOAT_TYPE, 137);
        OpcodeUtil.addARInsn(Type.LONG_TYPE, Type.DOUBLE_TYPE, 138);
        OpcodeUtil.addARInsn(Type.FLOAT_TYPE, Type.INT_TYPE, 139);
        OpcodeUtil.addARInsn(Type.FLOAT_TYPE, Type.LONG_TYPE, 140);
        OpcodeUtil.addARInsn(Type.FLOAT_TYPE, Type.DOUBLE_TYPE, 141);
        OpcodeUtil.addARInsn(Type.DOUBLE_TYPE, Type.INT_TYPE, 142);
        OpcodeUtil.addARInsn(Type.DOUBLE_TYPE, Type.LONG_TYPE, 143);
        OpcodeUtil.addARInsn(Type.DOUBLE_TYPE, Type.FLOAT_TYPE, 144);
        OpcodeUtil.addAInsn(Type.INT_TYPE, 170, 171);
        OpcodeUtil.addAInsn(Type.INT_TYPE, 172);
        OpcodeUtil.addAInsn(Type.LONG_TYPE, 173);
        OpcodeUtil.addAInsn(Type.FLOAT_TYPE, 174);
        OpcodeUtil.addAInsn(Type.DOUBLE_TYPE, 175);
        OpcodeUtil.addAInsn(Types.OBJECT_TYPE, 176);
        OpcodeUtil.addInsn(177);
    }

    private static void addInsn(int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(null, null), opcodes);
    }

    private static void addAInsn(Type argumentOperandType, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(new Type[]{argumentOperandType}, null), opcodes);
    }

    private static void addARInsn(Type argumentOperandType, Type resultOperandType, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(new Type[]{argumentOperandType}, resultOperandType), opcodes);
    }

    private static void addAAInsn(Type argumentOperandType1, Type argumentOperandType2, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(new Type[]{argumentOperandType1, argumentOperandType2}, null), opcodes);
    }

    private static void addAARInsn(Type argumentOperandType1, Type argumentOperandType2, Type resultOperandType, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(new Type[]{argumentOperandType1, argumentOperandType2}, resultOperandType), opcodes);
    }

    private static void addAAAInsn(Type argumentOperandType1, Type argumentOperandType2, Type argumentOperandType3, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(new Type[]{argumentOperandType1, argumentOperandType2, argumentOperandType3}, null), opcodes);
    }

    private static void addRInsn(Type resultOperandType, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(null, resultOperandType), opcodes);
    }

    private static void addInsns(InsnDescription insnDescription, int ... opcodes) {
        for (int opcode : opcodes) {
            assert (INSN_DESCRIPTIONS[opcode] == null);
            OpcodeUtil.INSN_DESCRIPTIONS[opcode] = insnDescription;
        }
    }

    public static InsnDescription getInsnDescription(int opcode) {
        return INSN_DESCRIPTIONS[opcode];
    }

    static {
        OpcodeUtil.initDescriptions();
    }

    public static final class InsnDescription {
        @Nullable
        public final Type[] argumentOperandTypes;
        @Nullable
        public final Type resultOperandType;

        public InsnDescription(@Nullable Type[] argumentOperandTypes, @Nullable Type resultOperandType) {
            this.argumentOperandTypes = argumentOperandTypes;
            this.resultOperandType = resultOperandType;
        }
    }
}

