/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.asm;

import de.unkrig.commons.asm.Types;
import de.unkrig.commons.nullanalysis.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;

public final class OpcodeUtil {
    private static final String[] OPCODE_NAMES;
    private static final InsnDescription[] INSN_DESCRIPTIONS;

    static {
        String[] stringArray = new String[256];
        stringArray[0] = "NOP";
        stringArray[1] = "ACONST_NULL";
        stringArray[2] = "ICONST_M1";
        stringArray[3] = "ICONST_0";
        stringArray[4] = "ICONST_1";
        stringArray[5] = "ICONST_2";
        stringArray[6] = "ICONST_3";
        stringArray[7] = "ICONST_4";
        stringArray[8] = "ICONST_5";
        stringArray[9] = "LCONST_0";
        stringArray[10] = "LCONST_1";
        stringArray[11] = "FCONST_0";
        stringArray[12] = "FCONST_1";
        stringArray[13] = "FCONST_2";
        stringArray[14] = "DCONST_0";
        stringArray[15] = "DCONST_1 = 15";
        stringArray[16] = "BIPUSH";
        stringArray[17] = "SIPUSH";
        stringArray[18] = "LDC";
        stringArray[19] = "LDC_W";
        stringArray[20] = "LDC2_W";
        stringArray[21] = "ILOAD";
        stringArray[22] = "LLOAD";
        stringArray[23] = "FLOAD";
        stringArray[24] = "DLOAD";
        stringArray[25] = "ALOAD";
        stringArray[26] = "ILOAD_0";
        stringArray[27] = "ILOAD_1";
        stringArray[28] = "ILOAD_2";
        stringArray[29] = "ILOAD_3";
        stringArray[30] = "LLOAD_0";
        stringArray[31] = "LLOAD_1";
        stringArray[32] = "LLOAD_2";
        stringArray[33] = "LLOAD_3";
        stringArray[34] = "FLOAD_0";
        stringArray[35] = "FLOAD_1";
        stringArray[36] = "FLOAD_2";
        stringArray[37] = "FLOAD_3";
        stringArray[38] = "DLOAD_0";
        stringArray[39] = "DLOAD_1";
        stringArray[40] = "DLOAD_2";
        stringArray[41] = "DLOAD_3";
        stringArray[42] = "ALOAD_0";
        stringArray[43] = "ALOAD_1";
        stringArray[44] = "ALOAD_2";
        stringArray[45] = "ALOAD_3";
        stringArray[46] = "IALOAD";
        stringArray[47] = "LALOAD";
        stringArray[48] = "FALOAD";
        stringArray[49] = "DALOAD";
        stringArray[50] = "AALOAD";
        stringArray[51] = "BALOAD";
        stringArray[52] = "CALOAD";
        stringArray[53] = "SALOAD";
        stringArray[54] = "ISTORE";
        stringArray[55] = "LSTORE";
        stringArray[56] = "FSTORE";
        stringArray[57] = "DSTORE";
        stringArray[58] = "ASTORE";
        stringArray[59] = "ISTORE_0";
        stringArray[60] = "ISTORE_1";
        stringArray[61] = "ISTORE_2";
        stringArray[62] = "ISTORE_3";
        stringArray[63] = "LSTORE_0";
        stringArray[64] = "LSTORE_1";
        stringArray[65] = "LSTORE_2";
        stringArray[66] = "LSTORE_3";
        stringArray[67] = "FSTORE_0";
        stringArray[68] = "FSTORE_1";
        stringArray[69] = "FSTORE_2";
        stringArray[70] = "FSTORE_3";
        stringArray[71] = "DSTORE_0";
        stringArray[72] = "DSTORE_1";
        stringArray[73] = "DSTORE_2";
        stringArray[74] = "DSTORE_3";
        stringArray[75] = "ASTORE_0";
        stringArray[76] = "ASTORE_1";
        stringArray[77] = "ASTORE_2";
        stringArray[78] = "ASTORE_3";
        stringArray[79] = "IASTORE";
        stringArray[80] = "LASTORE";
        stringArray[81] = "FASTORE";
        stringArray[82] = "DASTORE";
        stringArray[83] = "AASTORE";
        stringArray[84] = "BASTORE";
        stringArray[85] = "CASTORE";
        stringArray[86] = "SASTORE";
        stringArray[87] = "POP";
        stringArray[88] = "POP2";
        stringArray[89] = "DUP";
        stringArray[90] = "DUP_X1";
        stringArray[91] = "DUP_X2";
        stringArray[92] = "DUP2";
        stringArray[93] = "DUP2_X1";
        stringArray[94] = "DUP2_X2";
        stringArray[95] = "SWAP";
        stringArray[96] = "IADD";
        stringArray[97] = "LADD";
        stringArray[98] = "FADD";
        stringArray[99] = "DADD";
        stringArray[100] = "ISUB";
        stringArray[101] = "LSUB";
        stringArray[102] = "FSUB";
        stringArray[103] = "DSUB";
        stringArray[104] = "IMUL";
        stringArray[105] = "LMUL";
        stringArray[106] = "FMUL";
        stringArray[107] = "DMUL";
        stringArray[108] = "IDIV";
        stringArray[109] = "LDIV";
        stringArray[110] = "FDIV";
        stringArray[111] = "DDIV";
        stringArray[112] = "IREM";
        stringArray[113] = "LREM";
        stringArray[114] = "FREM";
        stringArray[115] = "DREM";
        stringArray[116] = "INEG";
        stringArray[117] = "LNEG";
        stringArray[118] = "FNEG";
        stringArray[119] = "DNEG";
        stringArray[120] = "ISHL";
        stringArray[121] = "LSHL";
        stringArray[122] = "ISHR";
        stringArray[123] = "LSHR";
        stringArray[124] = "IUSHR";
        stringArray[125] = "LUSHR";
        stringArray[126] = "IAND";
        stringArray[127] = "LAND";
        stringArray[128] = "IOR";
        stringArray[129] = "LOR";
        stringArray[130] = "IXOR";
        stringArray[131] = "LXOR";
        stringArray[132] = "IINC";
        stringArray[133] = "I2L";
        stringArray[134] = "I2F";
        stringArray[135] = "I2D";
        stringArray[136] = "L2I";
        stringArray[137] = "L2F";
        stringArray[138] = "L2D";
        stringArray[139] = "F2I";
        stringArray[140] = "F2L";
        stringArray[141] = "F2D";
        stringArray[142] = "D2I";
        stringArray[143] = "D2L";
        stringArray[144] = "D2F";
        stringArray[145] = "I2B";
        stringArray[146] = "I2C";
        stringArray[147] = "I2S";
        stringArray[148] = "LCMP";
        stringArray[149] = "FCMPL";
        stringArray[150] = "FCMPG";
        stringArray[151] = "DCMPL";
        stringArray[152] = "DCMPG";
        stringArray[153] = "IFEQ";
        stringArray[154] = "IFNE";
        stringArray[155] = "IFLT";
        stringArray[156] = "IFGE";
        stringArray[157] = "IFGT";
        stringArray[158] = "IFLE";
        stringArray[159] = "IF_ICMPEQ";
        stringArray[160] = "IF_ICMPNE";
        stringArray[161] = "IF_ICMPLT";
        stringArray[162] = "IF_ICMPGE";
        stringArray[163] = "IF_ICMPGT";
        stringArray[164] = "IF_ICMPLE";
        stringArray[165] = "IF_ACMPEQ";
        stringArray[166] = "IF_ACMPNE";
        stringArray[167] = "GOTO";
        stringArray[168] = "JSR";
        stringArray[169] = "RET";
        stringArray[170] = "TABLESWITCH";
        stringArray[171] = "LOOKUPSWITCH";
        stringArray[172] = "IRETURN";
        stringArray[173] = "LRETURN";
        stringArray[174] = "FRETURN";
        stringArray[175] = "DRETURN";
        stringArray[176] = "ARETURN";
        stringArray[177] = "RETURN";
        stringArray[178] = "GETSTATIC";
        stringArray[179] = "PUTSTATIC";
        stringArray[180] = "GETFIELD";
        stringArray[181] = "PUTFIELD";
        stringArray[182] = "INVOKEVIRTUAL";
        stringArray[183] = "INVOKESPECIAL";
        stringArray[184] = "INVOKESTATIC";
        stringArray[185] = "INVOKEINTERFACE";
        stringArray[186] = "INVOKEDYNAMIC";
        stringArray[187] = "NEW";
        stringArray[188] = "NEWARRAY";
        stringArray[189] = "ANEWARRAY";
        stringArray[190] = "ARRAYLENGTH";
        stringArray[191] = "ATHROW";
        stringArray[192] = "CHECKCAST";
        stringArray[193] = "INSTANCEOF";
        stringArray[194] = "MONITORENTER";
        stringArray[195] = "MONITOREXIT";
        stringArray[196] = "WIDE";
        stringArray[197] = "MULTIANEWARRAY";
        stringArray[198] = "IFNULL";
        stringArray[199] = "IFNONNULL";
        stringArray[200] = "GOTO_W";
        stringArray[201] = "JSR_W";
        OPCODE_NAMES = stringArray;
        INSN_DESCRIPTIONS = new InsnDescription[256];
        OpcodeUtil.initDescriptions();
    }

    private OpcodeUtil() {
    }

    public static String getName(AbstractInsnNode ain) {
        return OPCODE_NAMES[ain.getOpcode()];
    }

    private static void initDescriptions() {
        OpcodeUtil.addRInsn(Type.INT_TYPE, 21);
        OpcodeUtil.addRInsn(Type.LONG_TYPE, 22);
        OpcodeUtil.addRInsn(Type.FLOAT_TYPE, 23);
        OpcodeUtil.addRInsn(Type.DOUBLE_TYPE, 24);
        OpcodeUtil.addRInsn(Types.OBJECT_TYPE, 25);
        OpcodeUtil.addAInsn(Type.INT_TYPE, 54);
        OpcodeUtil.addAInsn(Type.LONG_TYPE, 55);
        OpcodeUtil.addAInsn(Type.FLOAT_TYPE, 56);
        OpcodeUtil.addAInsn(Type.DOUBLE_TYPE, 57);
        OpcodeUtil.addAInsn(Types.OBJECT_TYPE, 58);
        OpcodeUtil.addAARInsn(Types.INT_ARRAY_TYPE, Type.INT_TYPE, Type.INT_TYPE, 46);
        OpcodeUtil.addAARInsn(Types.LONG_ARRAY_TYPE, Type.INT_TYPE, Type.LONG_TYPE, 47);
        OpcodeUtil.addAARInsn(Types.FLOAT_ARRAY_TYPE, Type.INT_TYPE, Type.FLOAT_TYPE, 48);
        OpcodeUtil.addAARInsn(Types.DOUBLE_ARRAY_TYPE, Type.INT_TYPE, Type.DOUBLE_TYPE, 49);
        OpcodeUtil.addAARInsn(Types.REFERENCE_ARRAY_TYPE, Type.INT_TYPE, Types.OBJECT_TYPE, 50);
        OpcodeUtil.addAARInsn(Types.BYTE_ARRAY_TYPE, Type.INT_TYPE, Type.BYTE_TYPE, 51);
        OpcodeUtil.addAARInsn(Types.CHAR_ARRAY_TYPE, Type.INT_TYPE, Type.CHAR_TYPE, 52);
        OpcodeUtil.addAARInsn(Types.SHORT_ARRAY_TYPE, Type.INT_TYPE, Type.SHORT_TYPE, 53);
        OpcodeUtil.addAAAInsn(Types.INT_ARRAY_TYPE, Type.INT_TYPE, Type.INT_TYPE, 79);
        OpcodeUtil.addAAAInsn(Types.LONG_ARRAY_TYPE, Type.INT_TYPE, Type.LONG_TYPE, 80);
        OpcodeUtil.addAAAInsn(Types.FLOAT_ARRAY_TYPE, Type.INT_TYPE, Type.LONG_TYPE, 81);
        OpcodeUtil.addAAAInsn(Types.DOUBLE_ARRAY_TYPE, Type.INT_TYPE, Type.DOUBLE_TYPE, 82);
        OpcodeUtil.addAAAInsn(Types.REFERENCE_ARRAY_TYPE, Type.INT_TYPE, Types.OBJECT_TYPE, 83);
        OpcodeUtil.addAAAInsn(Types.BYTE_ARRAY_TYPE, Type.INT_TYPE, Type.BYTE_TYPE, 84);
        OpcodeUtil.addAAAInsn(Types.CHAR_ARRAY_TYPE, Type.INT_TYPE, Type.CHAR_TYPE, 85);
        OpcodeUtil.addAAAInsn(Types.SHORT_ARRAY_TYPE, Type.INT_TYPE, Type.SHORT_TYPE, 86);
        OpcodeUtil.addAARInsn(Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 96, 100, 104, 108, 112, 126, 128, 130);
        OpcodeUtil.addAARInsn(Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 97, 101, 105, 109, 113, 127, 129, 131);
        OpcodeUtil.addAARInsn(Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, 98, 102, 106, 110, 114);
        OpcodeUtil.addAARInsn(Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 99, 103, 107, 111, 115);
        OpcodeUtil.addAARInsn(Type.LONG_TYPE, Type.LONG_TYPE, Type.INT_TYPE, 148);
        OpcodeUtil.addAARInsn(Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.INT_TYPE, 150, 149);
        OpcodeUtil.addAARInsn(Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.INT_TYPE, 152, 151);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.INT_TYPE, 116);
        OpcodeUtil.addARInsn(Type.LONG_TYPE, Type.LONG_TYPE, 117);
        OpcodeUtil.addARInsn(Type.FLOAT_TYPE, Type.FLOAT_TYPE, 118);
        OpcodeUtil.addARInsn(Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 119);
        OpcodeUtil.addAARInsn(Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 120, 122, 124);
        OpcodeUtil.addAARInsn(Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE, 121, 123, 125);
        OpcodeUtil.addAAInsn(Type.INT_TYPE, Type.INT_TYPE, 159, 160, 161, 162, 163, 164);
        OpcodeUtil.addAAInsn(Types.OBJECT_TYPE, Types.OBJECT_TYPE, 165, 166);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.LONG_TYPE, 133);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.FLOAT_TYPE, 134);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.DOUBLE_TYPE, 135);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.BYTE_TYPE, 145);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.CHAR_TYPE, 146);
        OpcodeUtil.addARInsn(Type.INT_TYPE, Type.SHORT_TYPE, 147);
        OpcodeUtil.addARInsn(Type.LONG_TYPE, Type.INT_TYPE, 136);
        OpcodeUtil.addARInsn(Type.LONG_TYPE, Type.FLOAT_TYPE, 137);
        OpcodeUtil.addARInsn(Type.LONG_TYPE, Type.DOUBLE_TYPE, 138);
        OpcodeUtil.addARInsn(Type.FLOAT_TYPE, Type.INT_TYPE, 139);
        OpcodeUtil.addARInsn(Type.FLOAT_TYPE, Type.LONG_TYPE, 140);
        OpcodeUtil.addARInsn(Type.FLOAT_TYPE, Type.DOUBLE_TYPE, 141);
        OpcodeUtil.addARInsn(Type.DOUBLE_TYPE, Type.INT_TYPE, 142);
        OpcodeUtil.addARInsn(Type.DOUBLE_TYPE, Type.LONG_TYPE, 143);
        OpcodeUtil.addARInsn(Type.DOUBLE_TYPE, Type.FLOAT_TYPE, 144);
        OpcodeUtil.addAInsn(Type.INT_TYPE, 170, 171);
        OpcodeUtil.addAInsn(Type.INT_TYPE, 172);
        OpcodeUtil.addAInsn(Type.LONG_TYPE, 173);
        OpcodeUtil.addAInsn(Type.FLOAT_TYPE, 174);
        OpcodeUtil.addAInsn(Type.DOUBLE_TYPE, 175);
        OpcodeUtil.addAInsn(Types.OBJECT_TYPE, 176);
        OpcodeUtil.addInsn(177);
    }

    private static void addInsn(int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(null, null), opcodes);
    }

    private static void addAInsn(Type argumentOperandType, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(new Type[]{argumentOperandType}, null), opcodes);
    }

    private static void addARInsn(Type argumentOperandType, Type resultOperandType, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(new Type[]{argumentOperandType}, resultOperandType), opcodes);
    }

    private static void addAAInsn(Type argumentOperandType1, Type argumentOperandType2, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(new Type[]{argumentOperandType1, argumentOperandType2}, null), opcodes);
    }

    private static void addAARInsn(Type argumentOperandType1, Type argumentOperandType2, Type resultOperandType, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(new Type[]{argumentOperandType1, argumentOperandType2}, resultOperandType), opcodes);
    }

    private static void addAAAInsn(Type argumentOperandType1, Type argumentOperandType2, Type argumentOperandType3, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(new Type[]{argumentOperandType1, argumentOperandType2, argumentOperandType3}, null), opcodes);
    }

    private static void addRInsn(Type resultOperandType, int ... opcodes) {
        OpcodeUtil.addInsns(new InsnDescription(null, resultOperandType), opcodes);
    }

    private static void addInsns(InsnDescription insnDescription, int ... opcodes) {
        int[] nArray = opcodes;
        int n = opcodes.length;
        int n2 = 0;
        while (n2 < n) {
            int opcode = nArray[n2];
            assert (INSN_DESCRIPTIONS[opcode] == null);
            OpcodeUtil.INSN_DESCRIPTIONS[opcode] = insnDescription;
            ++n2;
        }
    }

    public static InsnDescription getInsnDescription(int opcode) {
        return INSN_DESCRIPTIONS[opcode];
    }

    public static final class InsnDescription {
        @Nullable
        public final Type[] argumentOperandTypes;
        @Nullable
        public final Type resultOperandType;

        public InsnDescription(@Nullable Type[] argumentOperandTypes, @Nullable Type resultOperandType) {
            this.argumentOperandTypes = argumentOperandTypes;
            this.resultOperandType = resultOperandType;
        }
    }
}

