/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.autoauth.core;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.java6.Base64;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.net.TcpClient;
import de.unkrig.commons.net.TcpServer;
import de.unkrig.commons.net.authenticator.CustomAuthenticator;
import de.unkrig.commons.net.http.HttpClientConnectionHandler;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.HttpResponse;
import de.unkrig.commons.net.http.servlett.Servlett;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.logging.SimpleLogging;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.SocketException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    public static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    private InetAddress endpointAddress;
    private int endpointPort;
    @Nullable
    private InetAddress targetAddress;
    private int targetPort;
    private String prompt;
    private boolean handleProxyAuthentication;
    private boolean handleServerAuthentication;

    public Main() {
        SimpleLogging.init();
        this.endpointAddress = InetAddress.getLoopbackAddress();
        this.endpointPort = -1;
        this.targetAddress = null;
        this.targetPort = -1;
        this.prompt = "autoauth";
        this.handleProxyAuthentication = true;
        this.handleServerAuthentication = false;
    }

    public static void main(String[] args) throws IOException, Exception {
        Main main = new Main();
        args = CommandLineOptions.parse((String[])args, (Object)main);
        main.run();
    }

    @CommandLineOption
    public void help() throws IOException {
        IoUtil.copyResource(Main.class, (String)"Main.main(String[]).txt", (OutputStream)System.out, (boolean)false);
        System.exit(0);
    }

    @CommandLineOption
    public void setEndpointAddress(InetAddress address) {
        this.endpointAddress = address;
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.MANDATORY)
    public void setEndpointPort(int portNumber) {
        this.endpointPort = portNumber;
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.MANDATORY)
    public void setTargetAddress(InetAddress address) {
        this.targetAddress = address;
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.MANDATORY)
    public void setTargetPort(int portNumber) {
        this.targetPort = portNumber;
    }

    @CommandLineOption
    public void setPrompt(String text) {
        this.prompt = text;
    }

    @CommandLineOption
    public void setHandleServerAuthentication() {
        this.handleServerAuthentication = true;
    }

    @CommandLineOption
    public void dontHandleProxyAuthentication() {
        this.handleProxyAuthentication = false;
    }

    @CommandLineOption
    public void noWarn() {
        SimpleLogging.setNoWarn();
    }

    @CommandLineOption
    public void verbose() {
        SimpleLogging.setVerbose();
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public void debug() {
        SimpleLogging.setDebug();
    }

    private void run() throws Exception {
        final String[] cachedAuthorization = new String[1];
        final InetSocketAddress targetAddress = new InetSocketAddress(this.targetAddress, this.targetPort);
        Authenticator.setDefault((Authenticator)new CustomAuthenticator(CustomAuthenticator.CacheMode.USER_NAMES_AND_PASSWORDS, CustomAuthenticator.StoreMode.USER_NAMES_AND_PASSWORDS));
        final String proxyAuthorization = this.handleProxyAuthentication ? Main.basicCredentials(Authenticator.requestPasswordAuthentication(targetAddress.getHostName(), targetAddress.getAddress(), targetAddress.getPort(), "http", this.prompt, "basic", new URL("http://x"), Authenticator.RequestorType.PROXY)) : null;
        TcpServer.ConnectionHandler cch = new TcpServer.ConnectionHandler(){

            public void handleConnection(InputStream in, OutputStream out, InetSocketAddress localSocketAddress, InetSocketAddress remoteSocketAddress, Stoppable stoppable) throws Exception {
                Object servlett;
                LOGGER.fine("S<< Connecting to server '" + targetAddress + "' -- '" + targetAddress + "'");
                final TcpClient tcpClient = new TcpClient(targetAddress.getAddress(), targetAddress.getPort());
                final Servlett delegate = servlett = new Servlett(){

                    public void close() throws IOException {
                    }

                    public HttpResponse handleRequest(final HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
                        Level l;
                        if (proxyAuthorization != null) {
                            httpRequest.setHeader("Proxy-Authorization", proxyAuthorization);
                        }
                        if (LOGGER.isLoggable(l = Level.CONFIG)) {
                            final ConsumerWhichThrows<HttpResponse, IOException> tmp = sendProvisionalResponse;
                            sendProvisionalResponse = new ConsumerWhichThrows<HttpResponse, IOException>(){

                                public void consume(HttpResponse provisionalResponse) throws IOException {
                                    LOGGER.log(l, "{0} {1} => {2}", new Object[]{httpRequest.getMethod(), httpRequest.getUri(), provisionalResponse.getStatus()});
                                    tmp.consume((Object)provisionalResponse);
                                }
                            };
                        }
                        HttpResponse finalResponse = Main.processRequest(tcpClient, httpRequest, (ConsumerWhichThrows<HttpResponse, IOException>)sendProvisionalResponse);
                        LOGGER.log(l, "{0} {1} => {2}", new Object[]{httpRequest.getMethod(), httpRequest.getUri(), finalResponse.getStatus()});
                        return finalResponse;
                    }
                };
                servlett = new Servlett(){

                    public void close() throws IOException {
                        delegate.close();
                    }

                    public HttpResponse handleRequest(HttpRequest request, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
                        if (!Main.this.handleServerAuthentication) {
                            return delegate.handleRequest(request, sendProvisionalResponse);
                        }
                        HttpResponse response = delegate.handleRequest(request, sendProvisionalResponse);
                        if (response.getStatus() != HttpResponse.Status.UNAUTHORIZED) {
                            return response;
                        }
                        while (true) {
                            String wwwAuthenticate = response.getHeader("WWW-Authenticate");
                            Matcher m = Pattern.compile("(\\w+)(?: +realm *= *\"([^\"]*)\")?.*").matcher(wwwAuthenticate);
                            if (!m.matches()) break;
                            String scheme = m.group(1);
                            String realm = m.group(2);
                            if (!"basic".equalsIgnoreCase(scheme)) break;
                            String authorization = cachedAuthorization[0] != null ? cachedAuthorization[0] : Main.basicCredentials(Authenticator.requestPasswordAuthentication(request.getHeader("Host"), InetAddress.getByName(request.getUri().getHost()), request.getUri().getPort(), "http", realm, scheme, request.getUri().toURL(), Authenticator.RequestorType.SERVER));
                            request.setHeader("Authorization", authorization);
                            response = delegate.handleRequest(request, sendProvisionalResponse);
                            if (response.getStatus() != HttpResponse.Status.UNAUTHORIZED) {
                                cachedAuthorization[0] = authorization;
                                break;
                            }
                            cachedAuthorization[0] = null;
                        }
                        return response;
                    }
                };
                HttpClientConnectionHandler hcch = new HttpClientConnectionHandler(servlett);
                hcch.handleConnection(in, out, localSocketAddress, remoteSocketAddress, stoppable);
            }
        };
        new TcpServer(new InetSocketAddress(this.endpointAddress, this.endpointPort), 0, cch).run();
    }

    private static HttpResponse processRequest(final TcpClient tcpClient, final HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
        LOGGER.fine("S<< Sending request to remote proxy");
        ThreadUtil.runInBackground((RunnableWhichThrows)new RunnableWhichThrows<IOException>(){

            public void run() throws IOException {
                try {
                    httpRequest.write(tcpClient.getOutputStream(), "S<< ");
                    tcpClient.getOutputStream().flush();
                }
                catch (SocketException se) {
                    LOGGER.fine("S<< " + se);
                }
                catch (IOException ioe) {
                    throw (IOException)ExceptionUtil.wrap((String)"Sending request to remote proxy", (Throwable)ioe);
                }
            }
        }, (String)(Thread.currentThread().getName() + "-request"));
        while (true) {
            LOGGER.fine("S>> Reading response from remote server");
            HttpResponse httpResponse = HttpResponse.read((InputStream)tcpClient.getInputStream(), (String)httpRequest.getHttpVersion(), (HttpRequest.Method)httpRequest.getMethod(), (String)"S>> ");
            LOGGER.fine(httpRequest.getMethod() + " " + httpRequest.getUri() + " => " + httpResponse.getStatus() + " completely processed");
            if (!httpResponse.isProvisional()) {
                return httpResponse;
            }
            sendProvisionalResponse.consume((Object)httpResponse);
        }
    }

    @Nullable
    private static String basicCredentials(@Nullable PasswordAuthentication passwordAuthentication) {
        if (passwordAuthentication == null) {
            return null;
        }
        String userName = passwordAuthentication.getUserName();
        char[] password = passwordAuthentication.getPassword();
        if (userName == null || password == null) {
            return null;
        }
        return "Basic " + Base64.encode((byte[])(userName + ":" + new String(password)).getBytes());
    }
}

