/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.type;

import de.unkrig.commons.nullanalysis.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;

public class ResourceTransformer
extends ProjectComponent
implements ResourceCollection,
Iterable<Resource> {
    @Nullable
    private ResourceCollection delegate;
    private Transformation name = Transformation.NAME;
    private Transformation content = Transformation.CONTENT;
    private Charset contentCharset = Charset.defaultCharset();

    public void setName(Transformation value) {
        this.name = value;
    }

    public void setContent(Transformation value) {
        this.content = value;
    }

    public void setContentCharset(String charset) {
        this.contentCharset = Charset.forName(charset);
    }

    public void addConfigured(ResourceCollection value) {
        if (this.delegate != null) {
            throw new BuildException("No more than one resource collection subelement allowed");
        }
        this.delegate = value;
    }

    public boolean isFilesystemOnly() {
        return this.content == Transformation.CONTENT || this.content == Transformation.CONTENT_AS_FILE;
    }

    @Override
    public Iterator<Resource> iterator() {
        final ResourceCollection delegate = this.delegate;
        if (delegate == null) {
            throw new BuildException("Resource collection subelement missing");
        }
        return new Iterator<Resource>(){
            final Iterator<Resource> iter;
            {
                this.iter = delegate.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Resource next() {
                String name;
                final Resource resource = this.iter.next();
                switch (ResourceTransformer.this.name) {
                    case NAME: {
                        name = resource.getName();
                        break;
                    }
                    case CONTENT: {
                        name = ResourceTransformer.this.readContents(resource);
                        break;
                    }
                    default: {
                        throw new BuildException("'nameTransformation=\"" + (Object)((Object)ResourceTransformer.this.name) + "\" is not allowed");
                    }
                }
                Resource result = new Resource(name){

                    public long getSize() {
                        switch (ResourceTransformer.this.content) {
                            case NAME: {
                                return this.getName().getBytes(ResourceTransformer.this.contentCharset).length;
                            }
                            case NAME_AS_FILE: {
                                return (int)new File(resource.getName()).length();
                            }
                            case CONTENT: {
                                return resource.size();
                            }
                            case CONTENT_AS_FILE: {
                                return (int)new File(ResourceTransformer.this.readContents(resource)).length();
                            }
                        }
                        throw new IllegalArgumentException(String.valueOf((Object)ResourceTransformer.this.content));
                    }

                    public InputStream getInputStream() throws IOException {
                        switch (ResourceTransformer.this.content) {
                            case NAME: {
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                OutputStreamWriter w = new OutputStreamWriter(baos);
                                w.write(resource.getName());
                                w.close();
                                return new ByteArrayInputStream(baos.toByteArray());
                            }
                            case NAME_AS_FILE: {
                                return new FileInputStream(new File(resource.getName()));
                            }
                            case CONTENT: {
                                return resource.getInputStream();
                            }
                            case CONTENT_AS_FILE: {
                                return new FileInputStream(new File(ResourceTransformer.this.readContents(resource)));
                            }
                        }
                        throw new IllegalArgumentException(String.valueOf((Object)ResourceTransformer.this.content));
                    }

                    public boolean isExists() {
                        switch (ResourceTransformer.this.content) {
                            case NAME: {
                                return true;
                            }
                            case NAME_AS_FILE: {
                                return new File(resource.getName()).exists();
                            }
                            case CONTENT: {
                                return true;
                            }
                            case CONTENT_AS_FILE: {
                                return new File(ResourceTransformer.this.readContents(resource)).exists();
                            }
                        }
                        throw new IllegalArgumentException(String.valueOf((Object)ResourceTransformer.this.content));
                    }
                };
                result.setProject(ResourceTransformer.this.getProject());
                return result;
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    public int size() {
        ResourceCollection delegate = this.delegate;
        if (delegate == null) {
            throw new BuildException("Resource collection subelement missing");
        }
        return delegate.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContents(Resource resource) {
        String string;
        InputStreamReader r = new InputStreamReader(resource.getInputStream(), this.contentCharset);
        try {
            String content = ResourceTransformer.readAll(r);
            r.close();
            string = content;
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe);
            }
        }
        try {
            r.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return string;
    }

    private static String readAll(Reader r) throws IOException {
        int n;
        char[] buffer = new char[8192];
        StringWriter sw = new StringWriter();
        while ((n = r.read(buffer)) != -1) {
            sw.write(buffer, 0, n);
        }
        return sw.toString();
    }

    public static enum Transformation {
        NAME,
        NAME_AS_FILE,
        CONTENT,
        CONTENT_AS_FILE;

    }
}

