/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.type;

import de.unkrig.commons.io.CountingReader;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.json.Json;
import de.unkrig.commons.text.json.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;

public class JsonAsProperties
extends ProjectComponent {
    @Nullable
    private String name;

    public void setName(String propertyNamePrefix) {
        this.name = propertyNamePrefix;
    }

    public void execute(Reader r) throws BuildException {
        Json.Value value;
        BufferedReader br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        CountingReader cr = new CountingReader((Reader)br);
        try {
            value = new JsonParser((Reader)cr).parseValue();
        }
        catch (Exception pe) {
            throw new BuildException("Line " + cr.lineNumber() + ", column " + cr.columnNumber() + ": " + pe.getMessage(), (Throwable)pe);
        }
        String name = this.name;
        if (name == null) {
            throw new BuildException("Attribute 'name' missing");
        }
        class SetPropertyVisitor
        implements Json.ValueVisitor {
            final String propertyName;

            SetPropertyVisitor(String propertyName) {
                this.propertyName = propertyName;
            }

            public void visit(Json.Null nulL) {
                this.setProperty("null");
            }

            public void visit(Json.False falsE) {
                this.setProperty("false");
            }

            public void visit(Json.True truE) {
                this.setProperty("true");
            }

            public void visit(Json.Array array) {
                String format = "%0" + Integer.toString(array.elements.size() - 1).length() + "d";
                for (int i = 0; i < array.elements.size(); ++i) {
                    Json.Value element = (Json.Value)array.elements.get(i);
                    element.accept((Json.ValueVisitor)new SetPropertyVisitor(this.propertyName + '.' + String.format(format, i)));
                }
            }

            public void visit(Json.ObjecT object) {
                for (Json.Member member : object.members) {
                    member.value.accept((Json.ValueVisitor)new SetPropertyVisitor(this.propertyName + '.' + member.name.text));
                }
            }

            public void visit(Json.NumbeR number) {
                this.setProperty(number.value.toString());
            }

            public void visit(Json.StrinG string) {
                this.setProperty(string.text);
            }

            private void setProperty(String value) {
                JsonAsProperties.this.getProject().setProperty(this.propertyName, value);
            }
        }
        value.accept((Json.ValueVisitor)new SetPropertyVisitor(name));
    }
}

