/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.ArrayStack;
import de.unkrig.commons.util.collections.Stack;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XmlProperty2Task
extends Task {
    @Nullable
    private File file;
    private String prefix = "";
    private boolean lexical;
    private final MyErrorHandler errorHandler = new MyErrorHandler(this.getProject());
    @Nullable
    private String text;
    private final List<ResourceCollection> resourceCollections = new ArrayList<ResourceCollection>();

    public void setFile(File file) {
        this.file = file;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setLexical(boolean lexical) {
        this.lexical = lexical;
    }

    public void setFailOnWarning(boolean failOnWarning) {
        this.errorHandler.failOnWarning = failOnWarning;
    }

    public void setSuppressWarnings(boolean suppressWarnings) {
        this.errorHandler.suppressWarnings = suppressWarnings;
    }

    public void setFailOnError(boolean failOnError) {
        this.errorHandler.failOnError = failOnError;
    }

    public void setSuppressErrors(boolean suppressErrors) {
        this.errorHandler.suppressErrors = suppressErrors;
    }

    public void addConfigured(ResourceCollection resourceCollection) {
        this.resourceCollections.add(resourceCollection);
    }

    public void addText(String text) {
        if (!(text = text.trim()).isEmpty()) {
            this.text = text;
        }
    }

    public void execute() {
        try {
            this.execute2();
        }
        catch (SAXParseException spe) {
            String publicId = spe.getPublicId();
            throw new BuildException((publicId == null ? "Line " : publicId + ", line ") + spe.getLineNumber() + ", column " + spe.getColumnNumber() + ": " + spe.getMessage(), (Throwable)spe);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void execute2() throws IOException, SAXException {
        if (this.text != null) {
            String text = this.getProject().replaceProperties(this.text);
            this.execute3(new ByteArrayInputStream(text.getBytes(Charset.forName("UTF-8"))), null);
        }
        if (this.file != null) {
            this.execute3(new FileInputStream(this.file), this.file.getName());
        }
        for (ResourceCollection resourceCollection : this.resourceCollections) {
            for (Resource resource : resourceCollection) {
                this.execute3(resource.getInputStream(), resource.toString());
            }
        }
    }

    private void execute3(InputStream is, @Nullable String publicId) throws IOException, SAXException {
        XmlProperty2Task.execute4(is, publicId, this.prefix, this.lexical, this.getProject(), this.errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute4(InputStream is, @Nullable String publicId, String propertyNamePrefix, boolean lexical, Project project, ErrorHandler errorHandler) throws IOException, SAXException {
        try {
            XmlProperty2Task.execute5(is, publicId, lexical, propertyNamePrefix, project, errorHandler);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    private static void execute5(InputStream is, @Nullable String publicId, boolean lexical, final String propertyNamePrefix, final Project project, ErrorHandler errorHandler) throws IOException, SAXException {
        SAXParser saxParser;
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setValidating(false);
        try {
            saxParser = saxParserFactory.newSAXParser();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        @NotNullByDefault(value=false)
        class MyContentAndLexicalHandler
        implements ContentHandler,
        LexicalHandler {
            final Stack<1MyContentAndLexicalHandler.El> elementStack = new ArrayStack();

            MyContentAndLexicalHandler() {
            }

            @Override
            public void startDocument() {
                this.elementStack.push((Object)new 1MyContentAndLexicalHandler.El(propertyNamePrefix));
            }

            @Override
            public void endDocument() {
                assert (this.elementStack.size() == 1);
            }

            @Override
            public void startPrefixMapping(String prefix, String uri) {
            }

            @Override
            public void endPrefixMapping(String prefix) {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) {
                1MyContentAndLexicalHandler.El el = (1MyContentAndLexicalHandler.El)this.elementStack.peek();
                String p = el.prefix + el.index++ + '.' + qName + '.';
                for (int i = 0; i < atts.getLength(); ++i) {
                    project.setProperty(p + '_' + atts.getLocalName(i), atts.getValue(i));
                }
                this.elementStack.push((Object)new 1MyContentAndLexicalHandler.El(p));
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                1MyContentAndLexicalHandler.El el = (1MyContentAndLexicalHandler.El)this.elementStack.pop();
                project.setProperty(el.prefix + "$$", el.text.toString().trim());
            }

            @Override
            public void skippedEntity(String name) {
            }

            @Override
            public void setDocumentLocator(Locator locator) {
            }

            @Override
            public void processingInstruction(String target, String data) {
                1MyContentAndLexicalHandler.El el = (1MyContentAndLexicalHandler.El)this.elementStack.peek();
                project.setProperty(el.prefix + el.index++ + ".?", target + ' ' + data);
            }

            @Override
            public void ignorableWhitespace(char[] ch, int start, int length) {
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                String s = new String(ch, start, length);
                1MyContentAndLexicalHandler.El el = (1MyContentAndLexicalHandler.El)this.elementStack.peek();
                project.setProperty(el.prefix + el.index++ + (el.inCdata ? ".!" : ".$"), s);
                el.text.append(s);
            }

            @Override
            @NotNullByDefault(value=false)
            public void startEntity(String name) {
            }

            @Override
            @NotNullByDefault(value=false)
            public void endEntity(String name) {
            }

            @Override
            @NotNullByDefault(value=false)
            public void startDTD(String name, String publicId, String systemId) {
            }

            @Override
            public void endDTD() {
            }

            @Override
            public void startCDATA() {
                ((1MyContentAndLexicalHandler.El)this.elementStack.peek()).inCdata = true;
            }

            @Override
            public void endCDATA() {
                ((1MyContentAndLexicalHandler.El)this.elementStack.peek()).inCdata = false;
            }

            @Override
            @NotNullByDefault(value=false)
            public void comment(char[] ch, int start, int length) {
                String s = new String(ch, start, length);
                1MyContentAndLexicalHandler.El el = (1MyContentAndLexicalHandler.El)this.elementStack.peek();
                project.setProperty(el.prefix + el.index++ + ".#", s);
            }

            class 1MyContentAndLexicalHandler.El {
                final String prefix;
                int index;
                StringBuilder text = new StringBuilder();
                boolean inCdata;

                1MyContentAndLexicalHandler.El(String prefix) {
                    this.prefix = prefix;
                }
            }
        }
        MyContentAndLexicalHandler contentAndLexicalHandler = new MyContentAndLexicalHandler();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setErrorHandler(errorHandler);
        xmlReader.setContentHandler(contentAndLexicalHandler);
        if (lexical) {
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", contentAndLexicalHandler);
        }
        InputSource inputSource = new InputSource(is);
        inputSource.setPublicId(publicId);
        xmlReader.parse(inputSource);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    @NotNullByDefault(value=false)
    class MyErrorHandler
    implements ErrorHandler {
        private final Project project;
        private boolean failOnWarning;
        private boolean suppressWarnings;
        private boolean failOnError = true;
        private boolean suppressErrors;

        MyErrorHandler(Project project) {
            this.project = project;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (this.failOnWarning) {
                throw exception;
            }
            if (!this.suppressWarnings) {
                this.project.log(exception.getLocalizedMessage(), 1);
            }
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (this.failOnError) {
                throw exception;
            }
            if (!this.suppressErrors) {
                this.project.log(exception.getLocalizedMessage(), 0);
            }
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

