/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.logging.SimpleLogging;
import java.io.File;
import java.util.logging.Level;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SimpleLoggingTask
extends Task {
    @Nullable
    private File out;
    private boolean stdout;
    @Nullable
    private Level level;
    @Nullable
    private Boolean noWarn;
    @Nullable
    private Boolean quiet;
    @Nullable
    private Boolean normal;
    @Nullable
    private Boolean verbose;
    @Nullable
    private Debug debug;
    @Nullable
    private String spec;
    @Nullable
    private String formatter;

    public void setOut(File outputFile) {
        this.out = outputFile;
    }

    public void setStdout(boolean value) {
        this.stdout = value;
    }

    public void setLevel(String level) {
        this.level = Level.parse(level);
    }

    public void setNoWarn(boolean value) {
        this.noWarn = value;
    }

    public void setQuiet(boolean value) {
        this.quiet = value;
    }

    public void setNormal(boolean value) {
        this.normal = value;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void setDebug(Debug value) {
        this.debug = value;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public void setFormatter(String spec) {
        this.formatter = spec;
    }

    public void execute() throws BuildException {
        try {
            if (this.out != null) {
                SimpleLogging.setOut((File)this.out);
            }
            if (this.stdout) {
                SimpleLogging.setStdout();
            }
            if (this.level != null) {
                SimpleLogging.setLevel((Level)this.level);
            }
            if (this.noWarn == Boolean.TRUE) {
                SimpleLogging.setNoWarn();
            }
            if (this.quiet == Boolean.TRUE) {
                SimpleLogging.setQuiet();
            }
            if (this.normal == Boolean.TRUE) {
                SimpleLogging.setNormal();
            }
            if (this.verbose == Boolean.TRUE) {
                SimpleLogging.setVerbose();
            }
            if (this.debug != null) {
                switch (this.debug) {
                    case FINE: {
                        SimpleLogging.setLevel((Level)Level.FINE);
                        break;
                    }
                    case FINER: {
                        SimpleLogging.setLevel((Level)Level.FINER);
                        break;
                    }
                    case FINEST: {
                        SimpleLogging.setLevel((Level)Level.FINEST);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            if (this.formatter != null) {
                SimpleLogging.setFormatter((String)this.formatter);
            }
            if (this.spec != null) {
                SimpleLogging.configureLoggers((String)this.spec);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static enum Debug {
        FINE,
        FINER,
        FINEST;

    }
}

