/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.antology.util.FlowControlException;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.time.Duration;
import de.unkrig.commons.util.time.PointOfTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.property.LocalProperties;

public class Retry2Task
extends Task
implements TaskContainer {
    public static final double DEFAULT_RETRY_DELAY_EXPONENT = 1.0;
    @Nullable
    private Integer status;
    @Nullable
    private Integer retryCount;
    @Nullable
    private Duration retryDelay;
    private double retryDelayExponent = 1.0;
    @Nullable
    private PointOfTime delayIntervalBegin;
    private final List<Task> tasks = new ArrayList<Task>();

    public void setStatus(int n) {
        this.status = n;
    }

    public void setRetryCount(int n) {
        this.retryCount = n;
    }

    public void setRetryDelay(Duration duration) {
        this.retryDelay = duration;
    }

    public void setRetryDelayExponent(double value) {
        this.retryDelayExponent = value;
    }

    @Deprecated
    public void setDelayIntervalBegin(PointOfTime pointOfTime) {
        this.delayIntervalBegin = pointOfTime;
    }

    public void addTask(@Nullable Task task) {
        assert (task != null);
        this.tasks.add(task);
    }

    public boolean retry(int n) {
        Integer retryCount = this.retryCount;
        if (retryCount != null && n >= retryCount) {
            return false;
        }
        Duration retryDelay = this.retryDelay;
        if (retryDelay != null) {
            retryDelay = retryDelay.multiply(Math.pow(this.retryDelayExponent, n));
            PointOfTime delayIntervalBegin = this.delayIntervalBegin;
            if (delayIntervalBegin == null) {
                delayIntervalBegin = new PointOfTime();
            }
            this.log("Will retry in " + retryDelay + " (on " + delayIntervalBegin.add(retryDelay) + ")...", 2);
            try {
                Thread.sleep(retryDelay.milliseconds());
            }
            catch (InterruptedException ie) {
                throw new BuildException((Throwable)ie);
            }
        }
        this.log("Retrying...", 2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        int n = 0;
        while (true) {
            try {
                LocalProperties localProperties = LocalProperties.get((Project)this.getProject());
                localProperties.enterScope();
                try {
                    for (Task task : this.tasks) {
                        task.perform();
                    }
                }
                finally {
                    localProperties.exitScope();
                }
                return;
            }
            catch (RuntimeException re) {
                if (FlowControlException.isWrappedBy(re)) {
                    throw re;
                }
                Integer status = this.status;
                if (status != null) {
                    for (Throwable t = re; t != null; t = t.getCause()) {
                        ExitStatusException ese;
                        if (!(t instanceof ExitStatusException) || (ese = (ExitStatusException)t).getStatus() == status.intValue()) continue;
                        throw re;
                    }
                }
                for (Throwable t = re; t != null; t = t.getCause()) {
                    this.log(t.toString(), 2);
                }
                if (!this.retry(n)) {
                    throw new BuildException("Giving up after " + n + " retries: " + re.getMessage(), (Throwable)re);
                }
                ++n;
                continue;
            }
            break;
        }
    }
}

