/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.antology.type.Subelement;
import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public class LoggingTask
extends Task {
    private final List<LoggerElement> loggerElements = new ArrayList<LoggerElement>();

    public void addConfiguredLogger(LoggerElement element) {
        this.loggerElements.add(element);
    }

    public void execute() throws BuildException {
        try {
            for (LoggerElement loggerElement : this.loggerElements) {
                List<String> loggerNames = loggerElement.names;
                if (loggerNames.isEmpty()) {
                    loggerNames = Collections.singletonList("");
                }
                for (String name : loggerNames) {
                    Logger logger = Logger.getLogger(name);
                    if (loggerElement.clearFilter) {
                        logger.setFilter(null);
                    }
                    if (loggerElement.filter != null) {
                        logger.setFilter(loggerElement.filter);
                    }
                    if (loggerElement.clearLevel) {
                        logger.setLevel(null);
                    }
                    if (loggerElement.level != null) {
                        logger.setLevel(loggerElement.level);
                    }
                    if (loggerElement.useParentHandlers != null) {
                        logger.setUseParentHandlers(loggerElement.useParentHandlers);
                    }
                    if (loggerElement.clearHandlers) {
                        for (Handler handler : logger.getHandlers()) {
                            logger.removeHandler(handler);
                        }
                    }
                    for (Handler handler : loggerElement.handlers) {
                        logger.addHandler(handler);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static <T> T convert(String value, Class<T> targetType) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (targetType == String.class) {
            return (T)value;
        }
        try {
            return targetType.getConstructor(String.class).newInstance(value);
        }
        catch (NoSuchMethodException nsme) {
            try {
                return (T)targetType.getField(value).get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new NoSuchMethodException(targetType + " has neither a single-string-arg constructor nor a constant " + value);
            }
        }
    }

    private static Object[] convert(List<String> values, Class<?>[] targetTypes) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object[] result = new Object[targetTypes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = LoggingTask.convert(values.get(i), targetTypes[i]);
        }
        return result;
    }

    public static class LoggerElement
    extends ProjectComponent {
        final List<String> names = new ArrayList<String>();
        public boolean clearLevel;
        @Nullable
        Level level;
        @Nullable
        Boolean useParentHandlers;
        public boolean clearFilter;
        @Nullable
        Filter filter;
        boolean clearHandlers;
        final List<Handler> handlers = new ArrayList<Handler>();

        public void setName(String name) {
            this.names.add(name);
        }

        public void addConfiguredName(Subelement.Value element) {
            if (element.value == null) {
                throw new IllegalArgumentException("'value' attribute of element '<name>' is missing");
            }
            this.names.add(element.value);
        }

        public void setClearLevel(boolean value) {
            this.clearLevel = value;
        }

        public void setLevel(String nameOrNumber) {
            this.level = Level.parse(nameOrNumber);
        }

        public void setUseParentHandlers(Boolean value) {
            this.useParentHandlers = value;
        }

        public void setClearFilter(boolean value) {
            this.clearFilter = value;
        }

        public void addConfiguredFilter(InstantiableElement element) throws Exception {
            if (this.filter != null) {
                throw new BuildException("At most one 'filter' subelement allowed");
            }
            this.filter = element.instantiate(Filter.class);
        }

        public void setClearHandlers(boolean value) {
            this.clearHandlers = value;
        }

        public void addConfiguredHandler(HandlerElement element) throws Exception {
            Handler handler = element.instantiate(Handler.class);
            if (element.filter != null) {
                handler.setFilter(element.filter);
            }
            if (element.formatter != null) {
                handler.setFormatter(element.formatter);
            }
            this.handlers.add(handler);
        }
    }

    public static class HandlerElement
    extends InstantiableElement {
        @Nullable
        Filter filter;
        @Nullable
        Formatter formatter;

        public void addConfiguredFilter(InstantiableElement element) throws Exception {
            if (this.filter != null) {
                throw new BuildException("At most one 'filter' subelement allowed");
            }
            this.filter = element.instantiate(Filter.class);
        }

        public void addConfiguredFormatter(InstantiableElement element) throws Exception {
            if (this.formatter != null) {
                throw new BuildException("At most one 'formatter' subelement allowed");
            }
            this.formatter = element.instantiate(Formatter.class);
        }
    }

    public static class InstantiableElement
    extends ProjectComponent {
        @Nullable
        String className;
        final List<String> arguments = new ArrayList<String>();
        final Map<String, String> attributes = new HashMap<String, String>();

        public void setClassName(String className) {
            this.className = className;
        }

        public void setArgument(String value) {
            this.arguments.add(value);
        }

        public void addConfiguredArgument(Subelement.Value element) {
            if (element.value == null) {
                throw new IllegalArgumentException("'value' attribute of element '<argument>' is missing");
            }
            this.arguments.add(element.value);
        }

        public void addConfiguredAttribute(Subelement.Name_Value element) {
            if (element.name == null) {
                throw new IllegalArgumentException("'name' attribute of element '<attribute>' is missing");
            }
            if (element.value == null) {
                throw new IllegalArgumentException("'value' attribute of element '<attribute>' is missing");
            }
            this.attributes.put(element.name, element.value);
        }

        <T> T instantiate(Class<T> superclass) throws Exception {
            Constructor<?> c2;
            Class<?> clasS;
            block7: {
                if (this.className == null) {
                    throw new IllegalArgumentException("'classname' attribute is missing");
                }
                clasS = Class.forName(this.className);
                if (!superclass.isAssignableFrom(clasS)) {
                    throw new IllegalArgumentException("'" + clasS.getName() + "' is not a subclass of '" + superclass.getName() + "'");
                }
                for (Constructor<?> c2 : clasS.getConstructors()) {
                    Class<?>[] parameterTypes = c2.getParameterTypes();
                    if (parameterTypes.length != this.arguments.size()) {
                        continue;
                    }
                    break block7;
                }
                throw new NoSuchMethodException(this.className + this.arguments);
            }
            Constructor<?> constructor = c2;
            Object object = constructor.newInstance(LoggingTask.convert(this.arguments, constructor.getParameterTypes()));
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                Class<?>[] parameterTypes;
                Method m2;
                String value;
                block8: {
                    String name = entry.getKey();
                    value = entry.getValue();
                    String methodName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
                    for (Method m2 : clasS.getMethods()) {
                        if (!m2.getName().equals(methodName) || (parameterTypes = m2.getParameterTypes()).length != 1) {
                            continue;
                        }
                        break block8;
                    }
                    throw new NoSuchMethodException(this.className + "::" + methodName);
                }
                Method method = m2;
                Class<?> parameterType = parameterTypes[0];
                method.invoke(object, LoggingTask.convert(value, parameterType));
            }
            return (T)object;
        }
    }
}

