/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.filter;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.Readers;
import de.unkrig.commons.io.WyeReader;
import de.unkrig.commons.nullanalysis.NotNull;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.ReaderInputStream;

@NotNullByDefault(value=false)
public class TeeFilter
extends ProjectComponent
implements ChainableReader {
    private final Vector<FilterChain> filterChains = new Vector();
    private static final Sink NULL_SINK = new Sink(){

        @Override
        public void readAll(Reader in) {
        }
    };
    private static final Sink STDOUT_SINK = new Sink(){

        @Override
        public void readAll(Reader in) throws IOException {
            IoUtil.copy((Readable)in, (Appendable)System.out);
        }
    };
    private static final Sink DEFAULT_SINK = NULL_SINK;
    @NotNull
    private Sink sink = DEFAULT_SINK;

    public Reader chain(Reader reader) {
        PipedReader pipedReader;
        final PipedWriter pipedWriter = new PipedWriter();
        try {
            pipedReader = new PipedReader(pipedWriter);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        WyeReader wyeReader = new WyeReader(reader, (Writer)pipedWriter);
        ChainReaderHelper crh = new ChainReaderHelper();
        crh.setPrimaryReader((Reader)pipedReader);
        crh.setFilterChains(this.filterChains);
        crh.setProject(this.getProject());
        final Reader reader2 = crh.getAssembledReader();
        final Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    TeeFilter.this.sink.readAll(reader2);
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
            }
        };
        thread.start();
        return new FilterReader((Reader)wyeReader){

            @Override
            public void close() throws IOException {
                super.close();
                pipedWriter.close();
                try {
                    thread.join();
                }
                catch (InterruptedException ie) {
                    throw new BuildException((Throwable)ie);
                }
            }
        };
    }

    public void setStdout(boolean value) {
        if (value) {
            this.setSink(STDOUT_SINK);
        }
    }

    public void addConfiguredProperties(PropertiesSink propertiesSink) {
        this.setSink(propertiesSink);
    }

    public void setTofile(Resource resource) {
        this.setSink(new ResourceSink(resource));
    }

    public void setProperty(final String propertyName) {
        this.setSink(new Sink(){

            @Override
            public void readAll(Reader in) throws IOException {
                TeeFilter.this.getProject().setNewProperty(propertyName, Readers.readAll((Reader)in));
            }
        });
    }

    public final void addFilterChain(FilterChain filterChain) {
        this.filterChains.addElement(filterChain);
    }

    private void setSink(@NotNull Sink sink) {
        if (this.sink != DEFAULT_SINK) {
            throw new BuildException("Must configure at most one of 'tofile=\"...\"', 'property=\"...\"', 'stdout=\"true\"' and '<properties>'");
        }
        this.sink = sink;
    }

    public static class ResourceSink
    implements Sink {
        private final Resource resource;

        public ResourceSink(Resource resource) {
            this.resource = resource;
        }

        @Override
        public void readAll(Reader in) throws IOException {
            IoUtil.copy((Reader)in, (OutputStream)this.resource.getOutputStream(), (Charset)Charset.defaultCharset());
        }
    }

    public static class PropertiesSink
    implements Sink {
        private boolean isXml;
        private final MyPropertyTask delegate = new MyPropertyTask();

        public void setIsXml(boolean value) {
            this.isXml = value;
        }

        public void setPrefix(String prefix) {
            this.delegate.setPrefix(prefix);
        }

        public void setPrefixValues(boolean b) {
            this.delegate.setPrefixValues(b);
        }

        @Override
        public void readAll(Reader r) throws IOException {
            Properties properties = new Properties();
            if (this.isXml) {
                properties.loadFromXML((InputStream)new ReaderInputStream(r));
            } else {
                properties.load(r);
            }
            this.delegate.addProperties(properties);
        }

        class MyPropertyTask
        extends Property {
            MyPropertyTask() {
            }

            public void addProperties(Properties props) {
                super.addProperties(props);
            }
        }
    }

    public static interface Sink {
        public void readAll(Reader var1) throws IOException;
    }
}

