/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.gtf;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.gtf.GTFField;
import de.unknownreality.dataframe.gtf.GTFFormat;
import de.unknownreality.dataframe.io.DataWriter;
import de.unknownreality.dataframe.io.ReadFormat;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GTFWriter
extends DataWriter {
    protected GTFWriter() {
    }

    public void write(BufferedWriter bufferedWriter, DataContainer<?, ?> dataContainer) {
        try {
            String[] headerNames = new String[dataContainer.getHeader().size()];
            HashSet<String> headerNameSet = new HashSet<String>();
            for (int i = 0; i < headerNames.length; ++i) {
                headerNames[i] = (String)dataContainer.getHeader().get(i);
                headerNameSet.add(headerNames[i]);
            }
            for (Row row : dataContainer) {
                StringBuilder gtfFields = new StringBuilder();
                StringBuilder attributes = new StringBuilder();
                for (GTFField gtfField : GTFField.values()) {
                    Object v = null;
                    if (headerNameSet.contains(gtfField.name)) {
                        v = row.get((Object)gtfField.name);
                    }
                    String s = v == null || Values.NA.isNA(v) ? "." : row.getString((Object)gtfField.name);
                    gtfFields.append(s).append('\t');
                }
                for (int i = 0; i < row.size(); ++i) {
                    String s;
                    Object v = row.get(i);
                    String string = s = v == null || Values.NA.isNA(v) ? "." : row.getString(i);
                    if (GTFField.isGTFField(headerNames[i])) continue;
                    attributes.append(headerNames[i]).append(" \"").append(s).append("\"; ");
                }
                String fieldsString = gtfFields.toString();
                String attrString = attributes.toString();
                if (attrString.isEmpty()) {
                    fieldsString = fieldsString + ".";
                    bufferedWriter.write(fieldsString);
                } else {
                    attrString = attrString.substring(0, attrString.length() - 1);
                    bufferedWriter.write(fieldsString);
                    bufferedWriter.write(attrString);
                }
                bufferedWriter.newLine();
                bufferedWriter.flush();
            }
        }
        catch (IOException e) {
            throw new DataFrameRuntimeException("error writing gtf", (Throwable)e);
        }
    }

    public Map<String, String> getSettings(DataFrame dataFrame) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        int i = 0;
        for (String columnName : dataFrame.getHeader()) {
            if (GTFField.isGTFField(columnName)) continue;
            attributes.put("attr:" + columnName, Integer.toString(i++));
        }
        return attributes;
    }

    public List<DataFrameColumn> getMetaColumns(DataFrame dataFrame) {
        ArrayList<DataFrameColumn> columns = new ArrayList<DataFrameColumn>();
        for (GTFField gtfField : GTFField.values()) {
            columns.add(gtfField.column);
        }
        for (DataFrameColumn column : dataFrame.getColumns()) {
            if (GTFField.isGTFField(column.getName())) continue;
            columns.add(column);
        }
        return columns;
    }

    public ReadFormat getReadFormat() {
        return new GTFFormat();
    }
}

