/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.gtf;

import java.util.ArrayList;

public class GTFUtil {
    public static String[] splitAttributes(String input) {
        String p;
        boolean inQuotation = false;
        boolean inDoubleQuotation = false;
        boolean escapeNext = false;
        int currentStart = 0;
        char[] chars = input.trim().toCharArray();
        boolean startOrSplit = true;
        boolean partQuoted = false;
        boolean containsEscapeChar = false;
        ArrayList<String> parts = new ArrayList<String>(32);
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            boolean escape = escapeNext;
            escapeNext = false;
            if (!escape && c == '\\') {
                chars[i] = '\u0000';
                escapeNext = true;
                containsEscapeChar = true;
                continue;
            }
            if (!escape && c == '\'') {
                if (inQuotation && !escape) {
                    inQuotation = false;
                    partQuoted = true;
                    continue;
                }
                if (!inDoubleQuotation && startOrSplit) {
                    inQuotation = true;
                    ++currentStart;
                }
                startOrSplit = false;
                continue;
            }
            if (!escape && c == '\"') {
                if (inDoubleQuotation && !escape) {
                    inDoubleQuotation = false;
                    partQuoted = true;
                    continue;
                }
                if (!inDoubleQuotation && startOrSplit) {
                    inDoubleQuotation = true;
                    ++currentStart;
                }
                startOrSplit = false;
                continue;
            }
            if (!(escape || c != ' ' && c != ';' && c != '=' || inDoubleQuotation || inQuotation)) {
                int length = i - currentStart;
                if (partQuoted) {
                    --length;
                    partQuoted = false;
                }
                if (length == 0) {
                    ++currentStart;
                    continue;
                }
                p = new String(chars, currentStart, length);
                if (containsEscapeChar) {
                    p = p.replace(Character.toString('\u0000'), "");
                }
                parts.add(p);
                currentStart = i + 1;
                startOrSplit = true;
                continue;
            }
            startOrSplit = false;
        }
        if (currentStart < chars.length) {
            int length = chars.length - currentStart;
            if (partQuoted) {
                --length;
            }
            p = new String(chars, currentStart, length);
            if (containsEscapeChar) {
                p = p.replace(Character.toString('\u0000'), "");
            }
            parts.add(p);
        }
        return parts.toArray(new String[parts.size()]);
    }
}

