/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.gtf;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.column.StringColumn;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.gtf.GTFField;
import de.unknownreality.dataframe.io.FormatSettings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GTFSettings
implements FormatSettings {
    private List<GTFField> gtfFields = new ArrayList<GTFField>();
    private Map<String, DataFrameColumn> attributes = new LinkedHashMap<String, DataFrameColumn>();
    private boolean addAllGTFFields = true;
    private FilterPredicate preFilter = null;

    public boolean isAddAllGTFFields() {
        return this.addAllGTFFields;
    }

    public void setAddAllGTFFields(boolean addAllGTFFields) {
        this.addAllGTFFields = addAllGTFFields;
    }

    public List<GTFField> getGtfFields() {
        return this.gtfFields;
    }

    public Map<String, DataFrameColumn> getAttributes() {
        return this.attributes;
    }

    public FilterPredicate getPreFilter() {
        return this.preFilter;
    }

    public void setPreFilter(FilterPredicate preFilter) {
        this.preFilter = preFilter;
    }

    public void addGTFField(GTFField field) {
        this.gtfFields.add(field);
        this.addAllGTFFields = false;
    }

    public void addAttribute(String name, DataFrameColumn column) {
        this.attributes.put(name, column);
    }

    public void addAttribute(String name, Class<? extends DataFrameColumn> columnClass) {
        DataFrameColumn column;
        try {
            column = columnClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DataFrameRuntimeException(String.format("error creating column instance '%s'", columnClass.getCanonicalName()), (Throwable)e);
        }
        this.addAttribute(name, column);
    }

    public void addAttribute(String name) {
        this.addAttribute(name, (DataFrameColumn)new StringColumn());
    }

    public void addColumn(String name) {
        GTFField field = GTFField.fromString(name);
        if (field != null) {
            this.addGTFField(field);
        } else {
            this.addAttribute(name);
        }
    }
}

